/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.services;

import java.util.Map;
import org.restheart.exchange.ByteArrayRequest;
import org.restheart.exchange.ByteArrayResponse;
import org.restheart.exchange.ServiceRequest;
import org.restheart.plugins.ByteArrayService;
import org.restheart.plugins.Inject;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.RegisterPlugin;

@RegisterPlugin(name="ping", description="simple ping service", secure=false, blocking=false)
public class PingService
implements ByteArrayService {
    private String msg = null;
    @Inject(value="config")
    private Map<String, Object> config;

    @OnInit
    public void setup() {
        this.msg = (String)this.argOrDefault(this.config, "msg", "Greetings from RESTHeart!");
    }

    public void handle(ByteArrayRequest request, ByteArrayResponse response) throws Exception {
        if (request.isGet()) {
            String accept = request.getHeader("Accept");
            if (accept != null && accept.startsWith("text/html")) {
                String content = "<div><h2>" + this.msg + "</h2></div>";
                response.setContent((Object)content.getBytes());
                response.setContentType("text/html");
            } else {
                response.setContentType("text/plain");
                response.setContent((Object)this.msg.getBytes());
            }
        } else if (request.isOptions()) {
            this.handleOptions((ServiceRequest)request);
        } else {
            response.setStatusCode(501);
        }
    }
}

