/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.utils;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.GsonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Set;
import org.fusesource.jansi.Ansi;
import org.restheart.Bootstrapper;
import org.restheart.configuration.Configuration;
import org.restheart.utils.FileUtils;
import org.restheart.utils.LoggingInitializer;
import org.restheart.utils.OSChecker;
import org.restheart.utils.RESTHeartDaemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapperUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Bootstrapper.class);
    private static final String INSTANCE = " instance ";
    private static final String STARTING = "Starting ";
    private static final String RESTHEART = "RESTHeart";
    private static final String VERSION = "Version {}";
    private static final String UNDEFINED = "undefined";

    public static String getInstanceName(Configuration configuration) {
        return configuration == null ? UNDEFINED : (configuration.coreModule().name() == null ? UNDEFINED : configuration.coreModule().name());
    }

    public static void setJsonpathDefaults() {
        com.jayway.jsonpath.Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new GsonJsonProvider();
            private final MappingProvider mappingProvider = new GsonMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }

    public static boolean checkPidFile(Path confFilePath, Path propFilePath) {
        if (OSChecker.isWindows()) {
            return false;
        }
        Path pidFilePath = BootstrapperUtils.pidFile(confFilePath, propFilePath);
        if (Files.exists(pidFilePath, new LinkOption[0])) {
            LOGGER.warn("Found pid file! If this instance is already running, startup will fail with a BindException");
            return true;
        }
        return false;
    }

    public static Path pidFile(Path confFilePath, Path confOverridesFilePath) {
        return FileUtils.getPidFilePath(FileUtils.getFileAbsolutePathHash(confFilePath, confOverridesFilePath));
    }

    public static void initLogging(Configuration configuration, RESTHeartDaemon d, boolean isForked) {
        LoggingInitializer.setLogLevel(configuration.logging().packages(), configuration.logging().logLevel());
        LoggingInitializer.applyFullstacktraceOption(configuration.logging().fullStacktrace());
        if (d != null && d.isDaemonized()) {
            LoggingInitializer.stopConsoleLogging();
            LoggingInitializer.startFileLogging(configuration.logging().logFilePath(), configuration.logging().fullStacktrace());
        } else if (!isForked) {
            if (!configuration.logging().logToConsole()) {
                LoggingInitializer.stopConsoleLogging();
            }
            if (configuration.logging().logToFile()) {
                LoggingInitializer.startFileLogging(configuration.logging().logFilePath(), configuration.logging().fullStacktrace());
            }
        }
    }

    public static void logStartMessages(Configuration configuration) {
        String instanceName = BootstrapperUtils.getInstanceName(configuration);
        LOGGER.info(STARTING + Ansi.ansi().fg(Ansi.Color.RED).bold().a(RESTHEART).reset().toString() + INSTANCE + Ansi.ansi().fg(Ansi.Color.RED).bold().a(instanceName).reset().toString());
        LOGGER.info(VERSION, (Object)Configuration.VERSION);
        LOGGER.debug("Configuration:\n" + configuration.toString());
    }

    public static void logLoggingConfiguration(Configuration configuration, boolean fork) {
        boolean usesLogback;
        String logbackConfigurationFile = System.getProperty("logback.configurationFile");
        boolean bl = usesLogback = logbackConfigurationFile != null && !logbackConfigurationFile.isEmpty();
        if (usesLogback) {
            return;
        }
        if (configuration.logging().logToFile()) {
            LOGGER.info("Logging to file {} with level {}", (Object)configuration.logging().logFilePath(), (Object)configuration.getLogLevel());
        }
        if (!fork) {
            if (!configuration.logging().logToConsole()) {
                LOGGER.info("Stop logging to console ");
            } else {
                LOGGER.info("Logging to console with level {}", (Object)configuration.getLogLevel());
            }
        }
    }
}

