/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.DeflateEncodingProvider;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.util.Arrays;
import org.restheart.Bootstrapper;
import org.restheart.exchange.ByteArrayProxyResponse;
import org.restheart.exchange.Exchange;
import org.restheart.handlers.ResponseSender;

public class ConfigurableEncodingHandler
extends EncodingHandler {
    private final ResponseSender sender = new ResponseSender(null);
    private boolean forceCompression = Bootstrapper.getConfiguration().coreModule().forceGzipEncoding();

    public ConfigurableEncodingHandler(HttpHandler next) {
        super(next, new ContentEncodingRepository().addEncodingHandler("gzip", (ContentEncodingProvider)new GzipEncodingProvider(), 60).addEncodingHandler("deflate", (ContentEncodingProvider)new DeflateEncodingProvider(), 50));
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.forceCompression) {
            HeaderValues acceptedEncodings = exchange.getRequestHeaders().get("Accept-Encoding");
            for (String values : acceptedEncodings) {
                if (!Arrays.stream(values.split(",")).anyMatch(v -> Headers.GZIP.toString().equals(v) || Headers.DEFLATE.toString().equals(v))) continue;
                super.handleRequest(exchange);
                return;
            }
            Exchange.setInError((HttpServerExchange)exchange);
            ByteArrayProxyResponse.of((HttpServerExchange)exchange).setInError(400, "Accept-Encoding header must include gzip or deflate");
            this.sender.handleRequest(exchange);
        } else {
            super.handleRequest(exchange);
        }
    }
}

