/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers;

import io.undertow.server.HttpServerExchange;
import org.restheart.Version;
import org.restheart.exchange.BadRequestException;
import org.restheart.exchange.PipelineInfo;
import org.restheart.exchange.Request;
import org.restheart.exchange.Response;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.handlers.ResponseSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandler
extends PipelinedHandler {
    private final PipelinedHandler sender = new ResponseSender(null);
    private final Logger LOGGER = LoggerFactory.getLogger(ErrorHandler.class);

    public ErrorHandler() {
        super(null);
    }

    public ErrorHandler(PipelinedHandler next) {
        super(next);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        try {
            this.next(exchange);
        }
        catch (NoClassDefFoundError ncdfe) {
            Response.of((HttpServerExchange)exchange).setInError(500, "Error handling the request, see logs for more information");
            PipelineInfo pi = Request.of((HttpServerExchange)exchange).getPipelineInfo();
            if (pi != null) {
                String errMsg = "Error handling the request. An external dependency appears to be missing for plugin type '" + pi.getType().name().toLowerCase() + "' with the name '" + pi.getName() + "'.Please copy the missing dependency JAR file to the plugins directory to ensure it's included in the classpath.";
                this.LOGGER.error(errMsg, (Throwable)ncdfe);
            } else {
                this.LOGGER.error("Error handling the request", (Throwable)ncdfe);
            }
            this.sender.handleRequest(exchange);
        }
        catch (LinkageError le) {
            PipelineInfo pi = Request.of((HttpServerExchange)exchange).getPipelineInfo();
            if (pi != null) {
                String version = Version.getInstance().getVersion() == null ? "of correct version" : "v" + Version.getInstance().getVersion();
                String errMsg = "Linkage error occurred while handling the request. Ensure that '" + pi.getType().name().toLowerCase() + "' with the name '" + pi.getName() + "' was compiled using the correct version of restheart-commons: " + version;
                this.LOGGER.error(errMsg, (Throwable)le);
            } else {
                this.LOGGER.error("Error handling the request", (Throwable)le);
            }
            Response.of((HttpServerExchange)exchange).setInError(500, "Error handling the request, see logs for more information", (Throwable)le);
            this.sender.handleRequest(exchange);
        }
        catch (BadRequestException bre) {
            Response.of((HttpServerExchange)exchange).setInError(bre.getStatusCode(), bre.getMessage());
            this.sender.handleRequest(exchange);
        }
        catch (Throwable t) {
            this.LOGGER.error("Error handling the request", t);
            Response.of((HttpServerExchange)exchange).setInError(500, "Error handling the request, see logs for more information", t);
            this.sender.handleRequest(exchange);
        }
    }
}

