/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers;

import io.undertow.server.HttpServerExchange;
import java.util.List;
import org.restheart.exchange.ByteArrayProxyRequest;
import org.restheart.exchange.ByteArrayProxyResponse;
import org.restheart.exchange.Exchange;
import org.restheart.exchange.Request;
import org.restheart.exchange.Response;
import org.restheart.exchange.ServiceRequest;
import org.restheart.exchange.ServiceResponse;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.Interceptor;
import org.restheart.plugins.InterceptorException;
import org.restheart.plugins.Plugin;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.PluginsRegistryImpl;
import org.restheart.plugins.Service;
import org.restheart.utils.LambdaUtils;
import org.restheart.utils.PluginUtils;
import org.restheart.utils.ThreadsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseInterceptorsExecutor
extends PipelinedHandler {
    static final Logger LOGGER = LoggerFactory.getLogger(ResponseInterceptorsExecutor.class);
    private final boolean filterRequiringContent;
    private final PluginsRegistry pluginsRegistry = PluginsRegistryImpl.getInstance();

    public ResponseInterceptorsExecutor() {
        this(null, false);
    }

    public ResponseInterceptorsExecutor(boolean filterRequiringContent) {
        this(null, filterRequiringContent);
    }

    public ResponseInterceptorsExecutor(PipelinedHandler next, boolean filterRequiringContent) {
        super(next);
        this.filterRequiringContent = filterRequiringContent;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ByteArrayProxyResponse response;
        ByteArrayProxyRequest request;
        Service handlingService = PluginUtils.handlingService((PluginsRegistry)this.pluginsRegistry, (HttpServerExchange)exchange);
        if (handlingService != null) {
            request = ServiceRequest.of((HttpServerExchange)exchange, ServiceRequest.class);
            response = ServiceResponse.of((HttpServerExchange)exchange, ServiceResponse.class);
        } else {
            request = ByteArrayProxyRequest.of((HttpServerExchange)exchange);
            response = ByteArrayProxyResponse.of((HttpServerExchange)exchange);
        }
        if (!Exchange.responseInterceptorsExecuted((HttpServerExchange)exchange)) {
            Exchange.setResponseInterceptorsExecuted((HttpServerExchange)exchange);
            this.executeAsyncResponseInterceptor(exchange, handlingService, (Request)request, (Response)response);
            this.executeResponseInterceptor(exchange, handlingService, (Request)request, (Response)response);
        }
        this.next(exchange);
    }

    private void executeResponseInterceptor(HttpServerExchange exchange, Service handlingService, Request request, Response response) {
        Exchange.setResponseInterceptorsExecuted((HttpServerExchange)exchange);
        List inteceptors = handlingService != null ? this.pluginsRegistry.getServiceInterceptors(handlingService, InterceptPoint.RESPONSE) : this.pluginsRegistry.getProxyInterceptors(InterceptPoint.RESPONSE);
        inteceptors.stream().filter(ri -> ri instanceof Interceptor).map(ri -> ri).filter(ri -> !this.filterRequiringContent || !PluginUtils.requiresContent((Interceptor)ri)).filter(ri -> {
            try {
                return ri.resolve(request, response);
            }
            catch (Exception ex) {
                LOGGER.warn("Error resolving interceptor {} for {} on intercept point {}", new Object[]{ri.getClass().getSimpleName(), exchange.getRequestPath(), InterceptPoint.RESPONSE, ex});
                Exchange.setInError((HttpServerExchange)exchange);
                LambdaUtils.throwsSneakyException((Throwable)new InterceptorException("Error resolving interceptor " + ri.getClass().getSimpleName(), (Throwable)ex));
                return false;
            }
        }).forEachOrdered(ri -> {
            LOGGER.debug("Executing interceptor {} for {} on intercept point {}", new Object[]{PluginUtils.name((Plugin)ri), exchange.getRequestPath(), InterceptPoint.RESPONSE});
            try {
                ri.handle(request, response);
            }
            catch (Exception ex) {
                LOGGER.error("Error executing interceptor {} for {} on intercept point {}", new Object[]{PluginUtils.name((Plugin)ri), exchange.getRequestPath(), InterceptPoint.RESPONSE, ex});
                Exchange.setInError((HttpServerExchange)exchange);
                LambdaUtils.throwsSneakyException((Throwable)new InterceptorException("Error executing interceptor " + ri.getClass().getSimpleName(), (Throwable)ex));
            }
        });
    }

    private void executeAsyncResponseInterceptor(HttpServerExchange exchange, Service handlingService, Request request, Response response) {
        List inteceptors = handlingService != null ? this.pluginsRegistry.getServiceInterceptors(handlingService, InterceptPoint.RESPONSE_ASYNC) : this.pluginsRegistry.getProxyInterceptors(InterceptPoint.RESPONSE_ASYNC);
        Exchange.setResponseInterceptorsExecuted((HttpServerExchange)exchange);
        inteceptors.stream().filter(ri -> ri instanceof Interceptor).map(ri -> ri).filter(ri -> !this.filterRequiringContent || !PluginUtils.requiresContent((Interceptor)ri)).filter(ri -> {
            try {
                return ri.resolve(request, response);
            }
            catch (Exception ex) {
                LOGGER.warn("Error resolving async interceptor {} for {} on intercept point {}", new Object[]{ri.getClass().getSimpleName(), exchange.getRequestPath(), InterceptPoint.RESPONSE_ASYNC});
                Exchange.setInError((HttpServerExchange)exchange);
                LambdaUtils.throwsSneakyException((Throwable)new InterceptorException("Error resolving async interceptor " + ri.getClass().getSimpleName(), (Throwable)ex));
                return false;
            }
        }).forEachOrdered(ri -> ThreadsUtils.virtualThreadsExecutor().execute(() -> {
            LOGGER.debug("Executing interceptor {} for {} on intercept point {}", new Object[]{PluginUtils.name((Plugin)ri), exchange.getRequestPath(), InterceptPoint.RESPONSE_ASYNC});
            try {
                ri.handle(request, response);
            }
            catch (Exception ex) {
                LOGGER.error("Error executing asyng interceptor {} for {} on intercept point {}", new Object[]{PluginUtils.name((Plugin)ri), exchange.getRequestPath(), InterceptPoint.RESPONSE_ASYNC, ex});
                Exchange.setInError((HttpServerExchange)exchange);
                LambdaUtils.throwsSneakyException((Throwable)new InterceptorException("Error executing async interceptor " + ri.getClass().getSimpleName(), (Throwable)ex));
            }
        }));
    }
}

