/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers;

import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.restheart.exchange.ByteArrayProxyResponse;
import org.restheart.exchange.PipelineInfo;
import org.restheart.exchange.ServiceResponse;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.PluginsRegistryImpl;
import org.restheart.plugins.Service;

public class ResponseSender
extends PipelinedHandler {
    private final PluginsRegistry pluginsRegistry = PluginsRegistryImpl.getInstance();

    public ResponseSender() {
        super(null);
    }

    public ResponseSender(PipelinedHandler next) {
        super(next);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String path = exchange.getRequestPath();
        PipelineInfo pi = this.pluginsRegistry.getPipelineInfo(path);
        if (pi.getType() == PipelineInfo.PIPELINE_TYPE.SERVICE) {
            Optional<PluginRecord> srv = this.pluginsRegistry.getServices().stream().filter(s -> s.getName().equals(pi.getName())).findAny();
            if (srv.isPresent()) {
                ServiceResponse response = (ServiceResponse)((Service)srv.get().getInstance()).response().apply(exchange);
                if (response.getStatusCode() > 0) {
                    exchange.setStatusCode(response.getStatusCode());
                }
                if (response.getCustomSender() != null) {
                    response.getCustomSender().run();
                } else {
                    String content = response.readContent();
                    if (content != null) {
                        exchange.getResponseSender().send(content);
                    }
                }
            }
        } else if (pi.getType() == PipelineInfo.PIPELINE_TYPE.PROXY) {
            ByteArrayProxyResponse response = ByteArrayProxyResponse.of((HttpServerExchange)exchange);
            if (!exchange.isResponseStarted() && response.getStatusCode() > 0) {
                exchange.setStatusCode(response.getStatusCode());
            }
            if (response.isContentAvailable()) {
                exchange.getResponseSender().send(ByteBuffer.wrap(response.readContent()));
            }
            exchange.endExchange();
        }
        this.next(exchange);
    }
}

