/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.restheart.Bootstrapper;
import org.restheart.exchange.ByteArrayProxyResponse;
import org.restheart.handlers.PipelinedHandler;
import org.slf4j.MDC;

public class TracingInstrumentationHandler
extends PipelinedHandler {
    private final List<String> traceHeaders;
    private final boolean emptyTraceHeaders;

    public TracingInstrumentationHandler() {
        List _th = Bootstrapper.getConfiguration().logging().tracingHeaders();
        this.traceHeaders = _th == null ? new ArrayList() : _th;
        this.emptyTraceHeaders = this.traceHeaders.isEmpty();
    }

    public TracingInstrumentationHandler(PipelinedHandler next) {
        super(next);
        List _th = Bootstrapper.getConfiguration().logging().tracingHeaders();
        this.traceHeaders = _th == null ? new ArrayList() : _th;
        this.emptyTraceHeaders = this.traceHeaders.isEmpty();
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.emptyTraceHeaders) {
            this.next(exchange);
        } else {
            this.traceHeaders.forEach(traceIdHeader -> Optional.ofNullable(exchange.getRequestHeaders().get(traceIdHeader)).flatMap(x -> Optional.ofNullable(x.peekFirst())).ifPresent(value -> {
                MDC.put((String)traceIdHeader, (String)value);
                ByteArrayProxyResponse.of((HttpServerExchange)exchange).setMDCContext(MDC.getCopyOfContextMap());
                exchange.getResponseHeaders().put(HttpString.tryFromString((String)traceIdHeader), value);
            }));
            if (!exchange.isResponseComplete() && this.getNext() != null) {
                this.next(exchange);
            }
            this.traceHeaders.forEach(traceIdHeader -> MDC.remove((String)traceIdHeader));
        }
    }
}

