/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers.injectors;

import io.undertow.util.HttpString;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.restheart.exchange.ServiceRequest;
import org.restheart.exchange.ServiceResponse;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.WildcardInterceptor;

@RegisterPlugin(name="dateHeader", description="Sets the Date response header", enabledByDefault=true, requiredinterceptor=true)
public class DateHeader
implements WildcardInterceptor {
    private static final HttpString DATE = HttpString.tryFromString((String)"Date");
    private static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private static final ZoneId GMT = ZoneId.of("GMT");

    public void handle(ServiceRequest<?> request, ServiceResponse<?> response) throws Exception {
        response.getHeaders().add(DATE, FORMATTER.format(ZonedDateTime.now(GMT)));
    }

    public boolean resolve(ServiceRequest<?> request, ServiceResponse<?> response) {
        return true;
    }
}

