/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers.injectors;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.RequestBufferingHandler;
import io.undertow.util.AttachmentKey;
import java.util.List;
import org.restheart.exchange.ByteArrayProxyRequest;
import org.restheart.exchange.ByteArrayProxyResponse;
import org.restheart.exchange.Exchange;
import org.restheart.exchange.Request;
import org.restheart.exchange.Response;
import org.restheart.exchange.ServiceRequest;
import org.restheart.exchange.ServiceResponse;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.Interceptor;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.PluginsRegistryImpl;
import org.restheart.plugins.Service;
import org.restheart.utils.PluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContentInjector
extends PipelinedHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestContentInjector.class);
    private static final AttachmentKey<Boolean> INJECTED_KEY = AttachmentKey.create(Boolean.class);
    private final Policy policy;
    private HttpHandler bufferingHandler = null;
    private final PluginsRegistry pluginsRegistry = PluginsRegistryImpl.getInstance();

    public RequestContentInjector(PipelinedHandler next, Policy policy) {
        super(next);
        this.bufferingHandler = new RequestBufferingHandler((HttpHandler)next, Exchange.MAX_BUFFERS);
        this.policy = policy;
    }

    public RequestContentInjector(Policy policy) {
        this.bufferingHandler = null;
        this.policy = policy;
    }

    protected void setNext(PipelinedHandler next) {
        super.setNext(next);
        this.bufferingHandler = new RequestBufferingHandler((HttpHandler)next, Exchange.MAX_BUFFERS);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.bufferingHandler == null) {
            throw new IllegalStateException("Cannot invoke handleRequest next if not set via setNext()");
        }
        if (this.shallInject(exchange, this.policy)) {
            if (LOGGER.isTraceEnabled()) {
                String ip = this.policy == Policy.ON_REQUIRES_CONTENT_AFTER_AUTH ? "AFTER_AUTH" : "BEFORE_AUTH";
                LOGGER.trace("Request content available for Request.getContent() at {}", (Object)ip);
            }
            this.markInjected(exchange);
            this.bufferingHandler.handleRequest(exchange);
        } else {
            if (LOGGER.isTraceEnabled()) {
                String ip = this.policy == Policy.ON_REQUIRES_CONTENT_AFTER_AUTH ? "AFTER_AUTH" : "BEFORE_AUTH";
                LOGGER.trace("Request content is not available for Request.getContent() at {}", (Object)ip);
            }
            this.next(exchange);
        }
    }

    private boolean shallInject(HttpServerExchange exchange, Policy policy) {
        return !this.isAlreadyInjected(exchange) && (policy == Policy.ALWAYS || policy == Policy.ON_REQUIRES_CONTENT_AFTER_AUTH && this.isContentRequired(exchange, InterceptPoint.REQUEST_AFTER_AUTH) || policy == Policy.ON_REQUIRES_CONTENT_BEFORE_AUTH && this.isContentRequired(exchange, InterceptPoint.REQUEST_BEFORE_AUTH));
    }

    private boolean isContentRequired(HttpServerExchange exchange, InterceptPoint interceptPoint) {
        List interceptors;
        ByteArrayProxyResponse response;
        ByteArrayProxyRequest request;
        Service handlingService = PluginUtils.handlingService((PluginsRegistry)this.pluginsRegistry, (HttpServerExchange)exchange);
        if (handlingService != null) {
            request = ServiceRequest.of((HttpServerExchange)exchange, ServiceRequest.class);
            response = ServiceResponse.of((HttpServerExchange)exchange, ServiceResponse.class);
            interceptors = this.pluginsRegistry.getServiceInterceptors(handlingService, interceptPoint);
        } else {
            request = ByteArrayProxyRequest.of((HttpServerExchange)exchange);
            response = ByteArrayProxyResponse.of((HttpServerExchange)exchange);
            interceptors = this.pluginsRegistry.getProxyInterceptors(interceptPoint);
        }
        return interceptors.stream().filter(ri -> ri instanceof Interceptor).map(ri -> ri).filter(arg_0 -> RequestContentInjector.lambda$isContentRequired$2((Request)request, (Response)response, exchange, interceptPoint, arg_0)).anyMatch(ri -> PluginUtils.requiresContent((Interceptor)ri));
    }

    private void markInjected(HttpServerExchange exchange) {
        exchange.putAttachment(INJECTED_KEY, (Object)true);
    }

    private boolean isAlreadyInjected(HttpServerExchange exchange) {
        return exchange.getAttachment(INJECTED_KEY) != null && (Boolean)exchange.getAttachment(INJECTED_KEY) != false;
    }

    private static /* synthetic */ boolean lambda$isContentRequired$2(Request request, Response response, HttpServerExchange exchange, InterceptPoint interceptPoint, Interceptor ri) {
        try {
            return ri.resolve(request, response);
        }
        catch (Exception e) {
            LOGGER.warn("Error resolving interceptor {} for {} on intercept point {} to check if the content is required; assuming requiresContent=false", new Object[]{ri.getClass().getSimpleName(), exchange.getRequestPath(), interceptPoint, e});
            return false;
        }
    }

    public static enum Policy {
        ALWAYS,
        ON_REQUIRES_CONTENT_BEFORE_AUTH,
        ON_REQUIRES_CONTENT_AFTER_AUTH;

    }
}

