/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers.injectors;

import io.undertow.util.HttpString;
import org.restheart.exchange.ServiceRequest;
import org.restheart.exchange.ServiceResponse;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.WildcardInterceptor;

@RegisterPlugin(name="xPoweredBy", description="Sets the X-Powered-By: restheart.org response header", enabledByDefault=true)
public class XPoweredBy
implements WildcardInterceptor {
    private static final HttpString X_POWERED_BY = HttpString.tryFromString((String)"X-Powered-By");
    private static final String RESTHEART_ORG = "restheart.org";

    public void handle(ServiceRequest<?> request, ServiceResponse<?> response) throws Exception {
        response.getHeaders().add(X_POWERED_BY, RESTHEART_ORG);
    }

    public boolean resolve(ServiceRequest<?> request, ServiceResponse<?> response) {
        return true;
    }
}

