/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.plugins;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import org.restheart.plugins.PluginsScanner;

public class PluginsClassloader
extends URLClassLoader {
    private static PluginsClassloader SINGLETON = null;

    public static void init(URL[] jars) {
        if (SINGLETON != null) {
            throw new IllegalStateException("already initialized");
        }
        try {
            SINGLETON = new PluginsClassloader(jars);
        }
        catch (IOException ioe) {
            throw new RuntimeException("error initializing", ioe);
        }
    }

    public static boolean isInitialized() {
        return SINGLETON != null;
    }

    private PluginsClassloader(URL[] jars) throws IOException {
        super(jars);
    }

    public static PluginsClassloader getInstance() {
        if (SINGLETON == null) {
            throw new IllegalStateException("not initialized");
        }
        return SINGLETON;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return PluginsScanner.class.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            return super.loadClass(name);
        }
    }
}

