/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.plugins;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.util.PathMatcher;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.restheart.cache.CacheFactory;
import org.restheart.cache.LoadingCache;
import org.restheart.configuration.ConfigurationException;
import org.restheart.exchange.ByteArrayProxyRequest;
import org.restheart.exchange.ByteArrayProxyResponse;
import org.restheart.exchange.PipelineInfo;
import org.restheart.handlers.BeforeExchangeInitInterceptorsExecutor;
import org.restheart.handlers.CORSHandler;
import org.restheart.handlers.ConfigurableEncodingHandler;
import org.restheart.handlers.ErrorHandler;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.handlers.PipelinedWrappingHandler;
import org.restheart.handlers.QueryStringRebuilder;
import org.restheart.handlers.RequestInterceptorsExecutor;
import org.restheart.handlers.RequestLogger;
import org.restheart.handlers.ResponseInterceptorsExecutor;
import org.restheart.handlers.ResponseSender;
import org.restheart.handlers.ServiceExchangeInitializer;
import org.restheart.handlers.TracingInstrumentationHandler;
import org.restheart.handlers.WorkingThreadsPoolDispatcher;
import org.restheart.handlers.injectors.PipelineInfoInjector;
import org.restheart.plugins.ExchangeTypeResolver;
import org.restheart.plugins.Initializer;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.Interceptor;
import org.restheart.plugins.Plugin;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsFactory;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.Provider;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.Service;
import org.restheart.plugins.WildcardInterceptor;
import org.restheart.plugins.security.AuthMechanism;
import org.restheart.plugins.security.Authenticator;
import org.restheart.plugins.security.Authorizer;
import org.restheart.plugins.security.TokenManager;
import org.restheart.security.BaseAclPermissionTransformer;
import org.restheart.security.authorizers.FullAuthorizer;
import org.restheart.security.handlers.SecurityHandler;
import org.restheart.utils.PluginUtils;

public class PluginsRegistryImpl
implements PluginsRegistry {
    private static final PathHandler ROOT_PATH_HANDLER = Handlers.path();
    private static final PathMatcher<PipelineInfo> PIPELINE_INFOS = new PathMatcher();
    private Set<PluginRecord<AuthMechanism>> authMechanisms;
    private Set<PluginRecord<Authenticator>> authenticators;
    private Set<BaseAclPermissionTransformer> permissionTransformers;
    private Set<PluginRecord<Authorizer>> authorizers;
    private Optional<PluginRecord<TokenManager>> tokenManager;
    private Set<PluginRecord<Provider<?>>> providers;
    private final Set<PluginRecord<Service<?, ?>>> services = new LinkedHashSet();
    private boolean servicesInitialized = false;
    private Set<PluginRecord<Initializer>> initializers;
    private Set<PluginRecord<Interceptor<?, ?>>> interceptors;
    private final LoadingCache<AbstractMap.SimpleEntry<String, InterceptPoint>, List<Interceptor<?, ?>>> SRV_INTERCEPTORS_CACHE = CacheFactory.createHashMapLoadingCache(key -> this.__interceptors((String)key.getKey(), (InterceptPoint)key.getValue()));

    public static PluginsRegistryImpl getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private PluginsRegistryImpl() {
    }

    public void instantiateAll() {
        PluginsFactory factory = PluginsFactory.getInstance();
        factory.providers();
        factory.initializers();
        factory.authMechanisms();
        factory.authorizers();
        factory.tokenManager();
        factory.authenticators();
        factory.interceptors();
        factory.services();
        factory.injectDependencies();
    }

    public Set<PluginRecord<AuthMechanism>> getAuthMechanisms() {
        if (this.authMechanisms == null) {
            this.authMechanisms = new LinkedHashSet<PluginRecord<AuthMechanism>>();
            this.authMechanisms.addAll(PluginsFactory.getInstance().authMechanisms());
        }
        return Collections.unmodifiableSet(this.authMechanisms);
    }

    public Set<PluginRecord<Authenticator>> getAuthenticators() {
        if (this.authenticators == null) {
            this.authenticators = new LinkedHashSet<PluginRecord<Authenticator>>();
            this.authenticators.addAll(PluginsFactory.getInstance().authenticators());
        }
        return Collections.unmodifiableSet(this.authenticators);
    }

    public PluginRecord<Authenticator> getAuthenticator(String name) throws ConfigurationException {
        Optional<PluginRecord> auth = this.getAuthenticators().stream().filter(p -> name.equals(p.getName())).findFirst();
        if (auth != null && auth.isPresent()) {
            return auth.get();
        }
        throw new ConfigurationException("Authenticator " + name + " not found");
    }

    public Set<BaseAclPermissionTransformer> getPermissionTransformers() {
        if (this.permissionTransformers == null) {
            this.permissionTransformers = Sets.newLinkedHashSet();
        }
        return this.permissionTransformers;
    }

    public PluginRecord<TokenManager> getTokenManager() {
        if (this.tokenManager == null) {
            PluginRecord<TokenManager> tm = PluginsFactory.getInstance().tokenManager();
            this.tokenManager = tm == null ? Optional.empty() : Optional.of(tm);
        }
        return this.tokenManager.isPresent() ? this.tokenManager.get() : null;
    }

    public Set<PluginRecord<Authorizer>> getAuthorizers() {
        if (this.authorizers == null) {
            this.authorizers = PluginsFactory.getInstance().authorizers();
        }
        return Collections.unmodifiableSet(this.authorizers);
    }

    public Set<PluginRecord<Initializer>> getInitializers() {
        if (this.initializers == null) {
            this.initializers = new LinkedHashSet<PluginRecord<Initializer>>();
            this.initializers.addAll(PluginsFactory.getInstance().initializers());
        }
        return Collections.unmodifiableSet(this.initializers);
    }

    public Set<PluginRecord<Interceptor<?, ?>>> getInterceptors() {
        if (this.interceptors == null) {
            this.interceptors = new LinkedHashSet();
            this.interceptors.addAll(PluginsFactory.getInstance().interceptors());
        }
        return Collections.unmodifiableSet(this.interceptors);
    }

    public Set<PluginRecord<Provider<?>>> getProviders() {
        if (this.providers == null) {
            this.providers = PluginsFactory.getInstance().providers();
        }
        return Collections.unmodifiableSet(this.providers);
    }

    public void addInterceptor(PluginRecord<Interceptor<?, ?>> i) {
        this.SRV_INTERCEPTORS_CACHE.invalidateAll();
        if (this.interceptors == null) {
            this.getInterceptors();
        }
        this.interceptors.add(i);
    }

    public boolean removeInterceptorIf(Predicate<? super PluginRecord<Interceptor<?, ?>>> filter) {
        this.SRV_INTERCEPTORS_CACHE.invalidateAll();
        return this.interceptors.removeIf(filter);
    }

    private List<Interceptor<?, ?>> __interceptors(String serviceName, InterceptPoint interceptPoint) {
        Set<Object> _interceptors;
        Optional _service;
        block2: {
            block3: {
                _service = serviceName == null ? Optional.empty() : this.getServices().stream().filter(pr -> serviceName.equals(pr.getName())).findFirst();
                _interceptors = this.getInterceptors();
                if (!_service.isPresent()) break block2;
                InterceptPoint[] vip = PluginUtils.dontIntercept((Service)((Service)((PluginRecord)_service.get()).getInstance()));
                if (Arrays.stream(vip).anyMatch(arg_0 -> interceptPoint.equals(arg_0))) break block3;
                if (!Arrays.stream(vip).anyMatch(arg_0 -> InterceptPoint.ANY.equals(arg_0))) break block2;
            }
            _interceptors = _interceptors.stream().filter(i -> PluginUtils.requiredinterceptor((Interceptor)((Interceptor)i.getInstance()))).collect(Collectors.toSet());
        }
        return _interceptors.stream().filter(ri -> ri.isEnabled()).map(ri -> (Interceptor)ri.getInstance()).filter(ri -> _service.isPresent() && PluginUtils.cachedRequestType((ExchangeTypeResolver)ri).equals(PluginUtils.cachedRequestType((ExchangeTypeResolver)((ExchangeTypeResolver)((PluginRecord)_service.get()).getInstance()))) && PluginUtils.cachedResponseType((ExchangeTypeResolver)ri).equals(PluginUtils.cachedResponseType((ExchangeTypeResolver)((ExchangeTypeResolver)((PluginRecord)_service.get()).getInstance()))) || _service.isPresent() && ri instanceof WildcardInterceptor || _service.isEmpty() && PluginUtils.cachedRequestType((ExchangeTypeResolver)ri).equals(ByteArrayProxyRequest.type()) && PluginUtils.cachedResponseType((ExchangeTypeResolver)ri).equals(ByteArrayProxyResponse.type())).filter(ri -> interceptPoint == PluginUtils.interceptPoint((Interceptor)ri)).collect(Collectors.toList());
    }

    public List<Interceptor<?, ?>> getServiceInterceptors(Service<?, ?> srv, InterceptPoint interceptPoint) {
        Objects.requireNonNull(srv);
        Objects.requireNonNull(interceptPoint);
        String serviceName = PluginUtils.name(srv);
        Optional _ret = this.SRV_INTERCEPTORS_CACHE.getLoading(new AbstractMap.SimpleEntry<String, InterceptPoint>(serviceName, interceptPoint));
        return _ret.isPresent() ? (List)_ret.get() : Lists.newArrayList();
    }

    public List<Interceptor<?, ?>> getProxyInterceptors(InterceptPoint interceptPoint) {
        Optional _ret = this.SRV_INTERCEPTORS_CACHE.getLoading(new AbstractMap.SimpleEntry<Object, InterceptPoint>(null, interceptPoint));
        return _ret.isPresent() ? (List)_ret.get() : Lists.newArrayList();
    }

    public Set<PluginRecord<Service<?, ?>>> getServices() {
        if (!this.servicesInitialized) {
            this.services.addAll(PluginsFactory.getInstance().services());
            this.servicesInitialized = true;
        }
        return Collections.unmodifiableSet(this.services);
    }

    public PathHandler getRootPathHandler() {
        return ROOT_PATH_HANDLER;
    }

    public void plugPipeline(String path, PipelinedHandler handler, PipelineInfo info) {
        if (info.getUriMatchPolicy() == RegisterPlugin.MATCH_POLICY.PREFIX) {
            ROOT_PATH_HANDLER.addPrefixPath(path, (HttpHandler)handler);
            PIPELINE_INFOS.addPrefixPath(path, (Object)info);
        } else {
            ROOT_PATH_HANDLER.addExactPath(path, (HttpHandler)handler);
            PIPELINE_INFOS.addExactPath(path, (Object)info);
        }
    }

    public PipelineInfo getPipelineInfo(String path) {
        PathMatcher.PathMatch m = PIPELINE_INFOS.match(path);
        return (PipelineInfo)m.getValue();
    }

    public void plugService(PluginRecord<Service<?, ?>> srv, String uri, RegisterPlugin.MATCH_POLICY mp, boolean secured) {
        SecurityHandler securityHandler;
        Set<PluginRecord<AuthMechanism>> _mechanisms = this.getAuthMechanisms();
        Set<PluginRecord<Authorizer>> _authorizers = this.getAuthorizers();
        PluginRecord<TokenManager> _tokenManager = this.getTokenManager();
        if (secured) {
            securityHandler = new SecurityHandler(_mechanisms, _authorizers, _tokenManager);
        } else {
            LinkedHashSet<PluginRecord<Authorizer>> _fauthorizers = new LinkedHashSet<PluginRecord<Authorizer>>();
            PluginRecord _fauthorizer = new PluginRecord("fullAuthorizer", "authorize any operation to any user", false, true, FullAuthorizer.class.getName(), (Plugin)new FullAuthorizer(false), null);
            _fauthorizers.add(_fauthorizer);
            securityHandler = new SecurityHandler(_mechanisms, _fauthorizers, _tokenManager);
        }
        boolean blockingSrv = PluginUtils.blocking((Service)((Service)srv.getInstance()));
        PipelinedHandler _srv = PipelinedHandler.pipe((PipelinedHandler[])new PipelinedHandler[]{blockingSrv ? new WorkingThreadsPoolDispatcher() : null, new ErrorHandler(), new PipelineInfoInjector(), new TracingInstrumentationHandler(), new RequestLogger(), new BeforeExchangeInitInterceptorsExecutor(), new ServiceExchangeInitializer(), new CORSHandler(), new RequestInterceptorsExecutor(InterceptPoint.REQUEST_BEFORE_AUTH), new QueryStringRebuilder(), securityHandler, new RequestInterceptorsExecutor(InterceptPoint.REQUEST_AFTER_AUTH), new QueryStringRebuilder(), PipelinedWrappingHandler.wrap((HttpHandler)new ConfigurableEncodingHandler((HttpHandler)PipelinedWrappingHandler.wrap((Service)((Service)srv.getInstance())))), new ResponseInterceptorsExecutor(), new ResponseSender()});
        this.plugPipeline(uri, _srv, new PipelineInfo(PipelineInfo.PIPELINE_TYPE.SERVICE, uri, mp, srv.getName()));
        this.services.add(srv);
        this.SRV_INTERCEPTORS_CACHE.invalidateAll();
    }

    public void unplug(String uri, RegisterPlugin.MATCH_POLICY mp) {
        PipelineInfo pi = this.getPipelineInfo(uri);
        this.services.removeIf(s -> s.getName().equals(pi.getName()));
        if (mp == RegisterPlugin.MATCH_POLICY.PREFIX) {
            ROOT_PATH_HANDLER.removePrefixPath(uri);
            PIPELINE_INFOS.removePrefixPath(uri);
        } else {
            ROOT_PATH_HANDLER.removeExactPath(uri);
            PIPELINE_INFOS.removeExactPath(uri);
        }
        this.SRV_INTERCEPTORS_CACHE.invalidateAll();
    }

    private static class SingletonHolder {
        private static final PluginsRegistryImpl INSTANCE;

        private SingletonHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            synchronized (classLoader) {
                Properties sysProps = System.getProperties();
                PluginsRegistryImpl singleton = (PluginsRegistryImpl)sysProps.get(PluginsRegistryImpl.class.getName());
                if (singleton != null) {
                    INSTANCE = singleton;
                } else {
                    INSTANCE = new PluginsRegistryImpl();
                    System.getProperties().put(PluginsRegistryImpl.class.getName(), INSTANCE);
                }
            }
        }
    }
}

