/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.plugins;

import graphql.Assert;
import io.github.classgraph.AnnotationEnumValue;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.FieldInfoList;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodInfoList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.restheart.Bootstrapper;
import org.restheart.graal.ImageInfo;
import org.restheart.plugins.FieldInjectionDescriptor;
import org.restheart.plugins.Initializer;
import org.restheart.plugins.Inject;
import org.restheart.plugins.InjectionDescriptor;
import org.restheart.plugins.Interceptor;
import org.restheart.plugins.MethodInjectionDescriptor;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.PluginDescriptor;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsClassloader;
import org.restheart.plugins.PluginsFactory;
import org.restheart.plugins.Provider;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.Service;
import org.restheart.plugins.security.AuthMechanism;
import org.restheart.plugins.security.Authenticator;
import org.restheart.plugins.security.Authorizer;
import org.restheart.plugins.security.TokenManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginsScanner {
    private static final String REGISTER_PLUGIN_CLASS_NAME;
    private static final String INITIALIZER_CLASS_NAME;
    private static final String AUTHMECHANISM_CLASS_NAME;
    private static final String AUTHORIZER_CLASS_NAME;
    private static final String TOKEN_MANAGER_CLASS_NAME;
    private static final String AUTHENTICATOR_CLASS_NAME;
    private static final String INTERCEPTOR_CLASS_NAME;
    private static final String SERVICE_CLASS_NAME;
    private static final String PROVIDER_CLASS_NAME;
    private static final ArrayList<PluginDescriptor> INITIALIZERS;
    private static final ArrayList<PluginDescriptor> AUTH_MECHANISMS;
    private static final ArrayList<PluginDescriptor> AUTHORIZERS;
    private static final ArrayList<PluginDescriptor> TOKEN_MANAGERS;
    private static final ArrayList<PluginDescriptor> AUTHENTICATORS;
    private static final ArrayList<PluginDescriptor> INTERCEPTORS;
    private static final ArrayList<PluginDescriptor> SERVICES;
    private static final ArrayList<PluginDescriptor> PROVIDERS;

    public static List<String> allPluginsClassNames() {
        ArrayList<String> ret = new ArrayList<String>();
        INITIALIZERS.stream().map(p -> p.clazz()).forEachOrdered(ret::add);
        AUTH_MECHANISMS.stream().map(p -> p.clazz()).forEachOrdered(ret::add);
        AUTHORIZERS.stream().map(p -> p.clazz()).forEachOrdered(ret::add);
        TOKEN_MANAGERS.stream().map(p -> p.clazz()).forEachOrdered(ret::add);
        AUTHENTICATORS.stream().map(p -> p.clazz()).forEachOrdered(ret::add);
        INTERCEPTORS.stream().map(p -> p.clazz()).forEachOrdered(ret::add);
        SERVICES.stream().map(p -> p.clazz()).forEachOrdered(ret::add);
        PROVIDERS.stream().map(p -> p.clazz()).forEachOrdered(ret::add);
        return ret;
    }

    static final List<PluginDescriptor> providers() {
        return PROVIDERS;
    }

    static final List<PluginDescriptor> initializers() {
        return INITIALIZERS;
    }

    static final List<PluginDescriptor> authMechanisms() {
        return AUTH_MECHANISMS;
    }

    static final List<PluginDescriptor> authorizers() {
        return AUTHORIZERS;
    }

    static final List<PluginDescriptor> tokenManagers() {
        return TOKEN_MANAGERS;
    }

    static final List<PluginDescriptor> authenticators() {
        return AUTHENTICATORS;
    }

    static final List<PluginDescriptor> interceptors() {
        return INTERCEPTORS;
    }

    static final List<PluginDescriptor> services() {
        return SERVICES;
    }

    private static List<PluginDescriptor> collectPlugins(ScanResult scanResult, String className) {
        ClassInfoList listOfType;
        ArrayList<PluginDescriptor> ret = new ArrayList<PluginDescriptor>();
        ClassInfoList registeredPlugins = scanResult.getClassesWithAnnotation(REGISTER_PLUGIN_CLASS_NAME);
        if (registeredPlugins == null || registeredPlugins.isEmpty()) {
            return ret;
        }
        if (className.equals(AUTHENTICATOR_CLASS_NAME)) {
            ClassInfoList tms = scanResult.getClassesImplementing(TOKEN_MANAGER_CLASS_NAME);
            listOfType = scanResult.getClassesImplementing(className).exclude(tms);
        } else {
            listOfType = scanResult.getClassesImplementing(className);
        }
        ClassInfoList plugins = registeredPlugins.intersect(new ClassInfoList[]{listOfType});
        return plugins.stream().map(c -> PluginsScanner.descriptor(c)).collect(Collectors.toList());
    }

    private static List<PluginDescriptor> collectProviders(ScanResult scanResult) {
        ArrayList<PluginDescriptor> ret = new ArrayList<PluginDescriptor>();
        ClassInfoList providers = scanResult.getClassesImplementing(PROVIDER_CLASS_NAME);
        if (providers == null || providers.isEmpty()) {
            return ret;
        }
        return providers.stream().map(c -> PluginsScanner.descriptor(c)).collect(Collectors.toList());
    }

    private static PluginDescriptor descriptor(ClassInfo pluginClassInfo) {
        String clazz = pluginClassInfo.getName();
        String name = pluginClassInfo.getAnnotationInfo(REGISTER_PLUGIN_CLASS_NAME).getParameterValues().stream().filter(p -> "name".equals(p.getName())).map(p -> p.getValue()).findAny().get().toString();
        return new PluginDescriptor(name, clazz, PluginsScanner.isEnabled(name, pluginClassInfo), PluginsScanner.collectInjections(pluginClassInfo));
    }

    private static ArrayList<InjectionDescriptor> collectInjections(ClassInfo pluginClassInfo) {
        ArrayList<InjectionDescriptor> ret = new ArrayList<InjectionDescriptor>();
        ret.addAll(PluginsScanner.collectFieldInjections(pluginClassInfo, Inject.class));
        ret.addAll(PluginsScanner.collectMethodInjections(pluginClassInfo, OnInit.class));
        return ret;
    }

    private static boolean isEnabled(String name, ClassInfo pluginClassInfo) {
        if (ImageInfo.inImageBuildtimeCode()) {
            return true;
        }
        boolean isEnabledByDefault = (Boolean)pluginClassInfo.getAnnotationInfo(REGISTER_PLUGIN_CLASS_NAME).getParameterValues().stream().filter(p -> "enabledByDefault".equals(p.getName())).map(p -> p.getValue()).findAny().get();
        Map confArgs = (Map)Bootstrapper.getConfiguration().getOrDefault(name, null);
        return PluginRecord.isEnabled((boolean)isEnabledByDefault, (Map)confArgs);
    }

    private static ArrayList<InjectionDescriptor> collectMethodInjections(ClassInfo pluginClassInfo, Class<?> clazz) {
        ArrayList<InjectionDescriptor> ret = new ArrayList<InjectionDescriptor>();
        MethodInfoList mil = pluginClassInfo.getDeclaredMethodInfo();
        for (MethodInfo mi : mil) {
            if (!mi.hasAnnotation(clazz.getName())) continue;
            ArrayList<AbstractMap.SimpleEntry<String, Object>> annotationParams = new ArrayList<AbstractMap.SimpleEntry<String, Object>>();
            for (AnnotationParameterValue p : mi.getAnnotationInfo(clazz.getName()).getParameterValues()) {
                Object value = p.getValue();
                if (value instanceof AnnotationEnumValue) {
                    AnnotationEnumValue annotationEnumValue = (AnnotationEnumValue)value;
                    PluginsScanner.removeRefToScanResult(annotationEnumValue);
                }
                annotationParams.add(new AbstractMap.SimpleEntry<String, Object>(p.getName(), value));
            }
            ArrayList<String> methodParams = new ArrayList<String>();
            Arrays.stream(mi.getParameterInfo()).forEachOrdered(pi -> methodParams.add(pi.getTypeDescriptor().toString()));
            ret.add(new MethodInjectionDescriptor(mi.getName(), clazz, annotationParams, methodParams, mi.hashCode()));
        }
        return ret;
    }

    private static ArrayList<InjectionDescriptor> collectFieldInjections(ClassInfo pluginClassInfo, Class<?> clazz) {
        ArrayList<InjectionDescriptor> ret = new ArrayList<InjectionDescriptor>();
        FieldInfoList fil = pluginClassInfo.getDeclaredFieldInfo();
        for (FieldInfo fi : fil) {
            if (!fi.hasAnnotation(clazz.getName())) continue;
            ArrayList<AbstractMap.SimpleEntry<String, Object>> annotationParams = new ArrayList<AbstractMap.SimpleEntry<String, Object>>();
            for (AnnotationParameterValue p : fi.getAnnotationInfo(clazz.getName()).getParameterValues()) {
                Object value = p.getValue();
                if (value instanceof AnnotationEnumValue) {
                    AnnotationEnumValue annotationEnumValue = (AnnotationEnumValue)value;
                    PluginsScanner.removeRefToScanResult(annotationEnumValue);
                }
                annotationParams.add(new AbstractMap.SimpleEntry<String, Object>(p.getName(), value));
            }
            try {
                Class<?> fieldClass = PluginsClassloader.getInstance().loadClass(fi.getTypeDescriptor().toString());
                ret.add(new FieldInjectionDescriptor(fi.getName(), fieldClass, annotationParams, fi.hashCode()));
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe);
            }
        }
        return ret;
    }

    private static void removeRefToScanResult(AnnotationEnumValue obj) {
        try {
            Field f = AnnotationEnumValue.class.getSuperclass().getDeclaredField("scanResult");
            f.setAccessible(true);
            f.set(obj, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
    }

    static {
        ClassGraph classGraph;
        REGISTER_PLUGIN_CLASS_NAME = RegisterPlugin.class.getName();
        INITIALIZER_CLASS_NAME = Initializer.class.getName();
        AUTHMECHANISM_CLASS_NAME = AuthMechanism.class.getName();
        AUTHORIZER_CLASS_NAME = Authorizer.class.getName();
        TOKEN_MANAGER_CLASS_NAME = TokenManager.class.getName();
        AUTHENTICATOR_CLASS_NAME = Authenticator.class.getName();
        INTERCEPTOR_CLASS_NAME = Interceptor.class.getName();
        SERVICE_CLASS_NAME = Service.class.getName();
        PROVIDER_CLASS_NAME = Provider.class.getName();
        INITIALIZERS = new ArrayList();
        AUTH_MECHANISMS = new ArrayList();
        AUTHORIZERS = new ArrayList();
        TOKEN_MANAGERS = new ArrayList();
        AUTHENTICATORS = new ArrayList();
        INTERCEPTORS = new ArrayList();
        SERVICES = new ArrayList();
        PROVIDERS = new ArrayList();
        RuntimeClassGraph rtcg = null;
        if (ImageInfo.inImageBuildtimeCode()) {
            String jarPath = PluginsScanner.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            try {
                File jarFile = new File(jarPath);
                URL jarURL = jarFile.toURI().toURL();
                URL[] urls = new URL[]{jarURL};
                PluginsClassloader.init(urls);
            }
            catch (MalformedURLException mue) {
                System.err.println("Error initilizing PluginsClassloader on restheart uber jar " + jarPath + ". Exception: " + mue.getMessage());
            }
            classGraph = new ClassGraph().disableDirScanning().disableNestedJarScanning().disableRuntimeInvisibleAnnotations().overrideClassLoaders(new ClassLoader[]{PluginsClassloader.getInstance()}).ignoreParentClassLoaders().enableAnnotationInfo().enableMethodInfo().enableFieldInfo().ignoreFieldVisibility().initializeLoadedClasses();
        } else {
            rtcg = new RuntimeClassGraph();
            classGraph = rtcg.get();
            classGraph = classGraph.verbose(Bootstrapper.getConfiguration().coreModule().pluginsScanningVerbose());
            List pluginsPackages = Bootstrapper.getConfiguration().coreModule().pluginsPackages();
            if (!Bootstrapper.getConfiguration().coreModule().pluginsPackages().isEmpty()) {
                classGraph = classGraph.acceptPackages((String[])pluginsPackages.toArray(String[]::new));
            }
            rtcg.logStartScan();
        }
        try (ScanResult scanResult = classGraph.scan(Runtime.getRuntime().availableProcessors());){
            INITIALIZERS.addAll(PluginsScanner.collectPlugins(scanResult, INITIALIZER_CLASS_NAME));
            AUTH_MECHANISMS.addAll(PluginsScanner.collectPlugins(scanResult, AUTHMECHANISM_CLASS_NAME));
            AUTHORIZERS.addAll(PluginsScanner.collectPlugins(scanResult, AUTHORIZER_CLASS_NAME));
            TOKEN_MANAGERS.addAll(PluginsScanner.collectPlugins(scanResult, TOKEN_MANAGER_CLASS_NAME));
            AUTHENTICATORS.addAll(PluginsScanner.collectPlugins(scanResult, AUTHENTICATOR_CLASS_NAME));
            INTERCEPTORS.addAll(PluginsScanner.collectPlugins(scanResult, INTERCEPTOR_CLASS_NAME));
            SERVICES.addAll(PluginsScanner.collectPlugins(scanResult, SERVICE_CLASS_NAME));
            PROVIDERS.addAll(PluginsScanner.collectProviders(scanResult));
        }
        if (rtcg != null) {
            rtcg.logEndScan();
        }
    }

    static class RuntimeClassGraph {
        private static final Logger LOGGER = LoggerFactory.getLogger(PluginsScanner.class);
        private final ClassGraph classGraph;
        URL[] jars = null;
        private long starScanTime = 0L;
        private long endScanTime = 0L;

        public RuntimeClassGraph() {
            Path pdir = this.getPluginsDirectory();
            this.jars = this.findPluginsJars(pdir);
            if (!PluginsClassloader.isInitialized()) {
                PluginsClassloader.init(this.jars);
            }
            this.classGraph = new ClassGraph().disableModuleScanning().disableDirScanning().disableNestedJarScanning().disableRuntimeInvisibleAnnotations().addClassLoader((ClassLoader)PluginsClassloader.getInstance()).addClassLoader(ClassLoader.getSystemClassLoader()).enableAnnotationInfo().enableMethodInfo().enableFieldInfo().ignoreFieldVisibility().initializeLoadedClasses();
        }

        public void logStartScan() {
            LOGGER.info("Scanning jars for plugins started");
            this.starScanTime = System.currentTimeMillis();
        }

        public void logEndScan() {
            this.endScanTime = System.currentTimeMillis();
            LOGGER.info("Scanning jars for plugins completed in {} msec", (Object)(this.endScanTime - this.starScanTime));
        }

        public ClassGraph get() {
            return this.classGraph;
        }

        private Path getPluginsDirectory() {
            Object pluginsDir = Bootstrapper.getConfiguration().coreModule().pluginsDirectory();
            if (pluginsDir == null) {
                return null;
            }
            if (((String)pluginsDir).startsWith("/")) {
                return Paths.get((String)pluginsDir, new String[0]);
            }
            URL location = PluginsFactory.class.getProtectionDomain().getCodeSource().getLocation();
            try {
                String decodedLocation = URLDecoder.decode(location.getPath(), StandardCharsets.UTF_8.toString());
                File locationFile = new File(decodedLocation);
                pluginsDir = locationFile.getParent() + File.separator + (String)pluginsDir;
                return FileSystems.getDefault().getPath((String)pluginsDir, new String[0]);
            }
            catch (UnsupportedEncodingException uee) {
                Assert.assertShouldNeverHappen();
                throw new RuntimeException(uee);
            }
        }

        private URL[] findPluginsJars(Path pluginsDirectory) {
            return this._findPluginsJars(pluginsDirectory, 0);
        }

        private URL[] _findPluginsJars(Path dir, int depth) {
            DirectoryStream<Path> ds;
            List pluginsPackages = Bootstrapper.getConfiguration().coreModule().pluginsPackages();
            if (!pluginsPackages.isEmpty()) {
                LOGGER.info("Limiting the scanning of plugins to packages {}", (Object)pluginsPackages);
            }
            if (dir == null) {
                return new URL[0];
            }
            try {
                this.checkPluginDirectory(dir);
            }
            catch (IllegalStateException ise) {
                return new URL[0];
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            try {
                ds = Files.newDirectoryStream(dir, "*.jar");
                try {
                    for (Path path : ds) {
                        URL jar2 = path.toUri().toURL();
                        if (!Files.isReadable(path)) {
                            LOGGER.error("Plugin jar {} is not readable", (Object)jar2);
                            throw new IllegalStateException("Plugin jar " + String.valueOf(jar2) + " is not readable");
                        }
                        urls.add(jar2);
                        LOGGER.info("Found plugin jar {}", (Object)URLDecoder.decode(jar2.getPath(), StandardCharsets.UTF_8.toString()));
                    }
                }
                finally {
                    if (ds != null) {
                        ds.close();
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.error("Cannot read jars in plugins directory {}", (Object)Bootstrapper.getConfiguration().coreModule().pluginsDirectory(), (Object)ex.getMessage());
            }
            if (depth < 2) {
                try {
                    ds = Files.newDirectoryStream(dir, entry -> Files.isDirectory(entry, new LinkOption[0]));
                    try {
                        for (Path subdir : ds) {
                            if (Files.isReadable(subdir)) {
                                URL[] subjars = this._findPluginsJars(subdir, depth + 1);
                                if (subjars == null || subjars.length <= 0) continue;
                                Arrays.stream(subjars).forEach(jar -> urls.add((URL)jar));
                                continue;
                            }
                            LOGGER.warn("Subdirectory {} of plugins directory {} is not readable", (Object)subdir, (Object)Bootstrapper.getConfiguration().coreModule().pluginsDirectory());
                        }
                    }
                    finally {
                        if (ds != null) {
                            ds.close();
                        }
                    }
                }
                catch (IOException ex) {
                    LOGGER.error("Cannot read jars in plugins subdirectory", (Object)ex.getMessage());
                }
            }
            return (URL[])urls.toArray(URL[]::new);
        }

        private void checkPluginDirectory(Path pluginsDirectory) {
            if (!Files.exists(pluginsDirectory, new LinkOption[0])) {
                LOGGER.warn("Plugin directory {} does not exist", (Object)pluginsDirectory);
                throw new IllegalStateException("Plugins directory " + String.valueOf(pluginsDirectory) + " does not exist");
            }
            if (!Files.isReadable(pluginsDirectory)) {
                LOGGER.warn("Plugin directory {} is not readable", (Object)pluginsDirectory);
                throw new IllegalStateException("Plugins directory " + String.valueOf(pluginsDirectory) + " is not readable");
            }
        }
    }
}

