/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.handlers;

import io.undertow.server.HttpServerExchange;
import java.util.Set;
import org.restheart.exchange.Request;
import org.restheart.handlers.CORSHandler;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.security.Authorizer;
import org.restheart.utils.PluginUtils;

public class AuthorizersHandler
extends PipelinedHandler {
    private final Set<PluginRecord<Authorizer>> authorizers;

    public AuthorizersHandler(Set<PluginRecord<Authorizer>> authorizers, PipelinedHandler next) {
        super(next);
        this.authorizers = authorizers;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Request request = Request.of((HttpServerExchange)exchange);
        if (this.isAllowed(request)) {
            this.next(exchange);
        } else {
            CORSHandler.injectAccessControlAllowHeaders(exchange);
            exchange.setStatusCode(403);
            exchange.endExchange();
        }
    }

    private boolean isAllowed(Request request) {
        if (this.authorizers == null || this.authorizers.isEmpty()) {
            return false;
        }
        return this.authorizers.stream().filter(a -> a.isEnabled()).filter(a -> a.getInstance() != null).map(a -> (Authorizer)a.getInstance()).filter(a -> PluginUtils.authorizerType((Authorizer)a) == Authorizer.TYPE.ALLOWER).filter(a -> !a.isAuthenticationRequired(request) || request.isAuthenticated()).anyMatch(a -> a.isAllowed(request)) && this.authorizers.stream().filter(a -> a.isEnabled()).filter(a -> a.getInstance() != null).map(a -> (Authorizer)a.getInstance()).filter(a -> !a.isAuthenticationRequired(request) || request.isAuthenticated()).filter(a -> PluginUtils.authorizerType((Authorizer)a) == Authorizer.TYPE.VETOER).allMatch(a -> a.isAllowed(request));
    }
}

