/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.utils;

import com.sun.akuma.CLibrary;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.restheart.configuration.Configuration;
import org.restheart.configuration.ConfigurationException;
import org.restheart.utils.OSChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);
    private static final Path DEFAULT_PID_DIR = new File("/var/run").toPath();
    private static final Path TMP_DIR = new File(System.getProperty("java.io.tmpdir")).toPath();

    public static Path getFileAbsolutePath(String path) {
        if (path == null) {
            return null;
        }
        return FileSystems.getDefault().getPath(path, new String[0]).toAbsolutePath();
    }

    public static int getFileAbsolutePathHash(Path confFilePath, Path propFilePath) {
        if (confFilePath == null) {
            return 0;
        }
        return Objects.hash(confFilePath, propFilePath);
    }

    public static Configuration getConfiguration(String[] args) throws ConfigurationException {
        return FileUtils.getConfiguration(args, false);
    }

    public static Configuration getConfiguration(String[] args, boolean silent) throws ConfigurationException {
        return Configuration.Builder.build((Path)FileUtils.getConfigurationFilePath(args), (Path)FileUtils.getOverrideFilePath(args), (boolean)false, (boolean)silent);
    }

    public static Path getConfigurationFilePath(String[] args) {
        if (args != null) {
            for (String arg : args) {
                if (arg.startsWith("-")) continue;
                return FileUtils.getFileAbsolutePath(arg);
            }
        }
        return null;
    }

    public static Path getOverrideFilePath(String[] args) {
        if (args != null) {
            List<String> _args = Arrays.asList(args);
            int opt = _args.indexOf("-o");
            return opt < 0 ? null : (_args.size() <= opt + 1 ? null : FileUtils.getFileAbsolutePath(_args.get(opt + 1)));
        }
        return null;
    }

    public static Path getTmpDirPath() {
        return TMP_DIR;
    }

    public static Path getPidFilePath(int configurationFileHash) {
        if (OSChecker.isWindows()) {
            return null;
        }
        if (Files.isWritable(DEFAULT_PID_DIR)) {
            return DEFAULT_PID_DIR.resolve("restheart-" + configurationFileHash + ".pid");
        }
        return TMP_DIR.resolve("restheart-" + configurationFileHash + ".pid");
    }

    public static void createPidFile(Path pidFile) {
        if (OSChecker.isWindows()) {
            LOGGER.warn("this method is not supported on Windows.");
            throw new IllegalStateException("createPidFile() is not supported on Windows.");
        }
        try (FileWriter fw = new FileWriter(pidFile.toFile());){
            fw.write(String.valueOf(CLibrary.LIBC.getpid()));
        }
        catch (IOException e) {
            LOGGER.warn("error writing pid file", (Throwable)e);
        }
    }

    public static int getPidFromFile(Path pidFile) {
        int n;
        BufferedReader br = new BufferedReader(new FileReader(pidFile.toFile()));
        try {
            String line = br.readLine();
            n = Integer.parseInt(line);
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException fne) {
                LOGGER.debug("pid file not found", (Throwable)fne);
                return -1;
            }
            catch (IOException e) {
                LOGGER.debug("error reading the pid file", (Throwable)e);
                return -2;
            }
            catch (NumberFormatException e) {
                LOGGER.debug("unexpected content in pid file", (Throwable)e);
                return -3;
            }
        }
        br.close();
        return n;
    }

    public static Set<Map.Entry<Object, Object>> findManifestInfo() {
        Set<Map.Entry<Object, Object>> result = null;
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL manifestUrl = resources.nextElement();
                Manifest manifest = new Manifest(manifestUrl.openStream());
                Attributes mainAttributes = manifest.getMainAttributes();
                String implementationTitle = mainAttributes.getValue("Implementation-Title");
                if (implementationTitle == null || !implementationTitle.toLowerCase().startsWith("restheart")) continue;
                result = mainAttributes.entrySet();
                break;
            }
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage());
        }
        return result;
    }

    private FileUtils() {
    }
}

