/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.utils;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.util.FileSize;
import java.util.List;
import org.slf4j.LoggerFactory;

public class LoggingInitializer {
    private static final int ASYNC_MAX_FLUSH_TIME = 5000;
    private static final int ASYNC_QUEUE_SIZE = 1024;

    public static void setLogLevel(List<String> packages, Level level) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        String logbackConfigurationFile = System.getProperty("logback.configurationFile");
        packages.stream().forEachOrdered(pack -> {
            Logger logger = loggerContext.getLogger(pack);
            if (logbackConfigurationFile != null && !logbackConfigurationFile.isEmpty()) {
                logger.info("Loglevel was set via logback configuration file with level {}", (Object)logger.getLevel());
            } else {
                logger.setLevel(level);
            }
        });
    }

    public static void applyFullstacktraceOption(boolean fullStacktrace) {
        if (!fullStacktrace) {
            return;
        }
        String logbackConfigurationFile = System.getProperty("logback.configurationFile");
        if (logbackConfigurationFile != null && !logbackConfigurationFile.isEmpty()) {
            return;
        }
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger rootLogger = loggerContext.getLogger("ROOT");
        Appender _ca = rootLogger.getAppender("STDOUT");
        if (_ca instanceof ConsoleAppender) {
            ConsoleAppender ca = (ConsoleAppender)_ca;
            Encoder _e = ca.getEncoder();
            if (_e != null) {
                _e.stop();
            }
            _ca.stop();
            rootLogger.detachAppender(_ca);
            ConsoleAppender newAppender = new ConsoleAppender();
            newAppender.setContext((Context)loggerContext);
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext((Context)loggerContext);
            encoder.setPattern("%d{HH:mm:ss.SSS} [%thread] %highlight(%-5level) %logger{36} - %msg%n %throwable{full}");
            encoder.start();
            newAppender.setEncoder((Encoder)encoder);
            newAppender.setName("STDOUT");
            newAppender.start();
            rootLogger.addAppender((Appender)newAppender);
        }
    }

    public static void stopConsoleLogging() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger rootLogger = loggerContext.getLogger("ROOT");
        Appender appender = rootLogger.getAppender("STDOUT");
        appender.stop();
    }

    public static void startFileLogging(String logFilePath, boolean fullStacktrace) {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        LoggerContext loggerContext = rootLogger.getLoggerContext();
        RollingFileAppender rfAppender = new RollingFileAppender();
        rfAppender.setContext((Context)loggerContext);
        rfAppender.setFile(logFilePath);
        FixedWindowRollingPolicy fwRollingPolicy = new FixedWindowRollingPolicy();
        fwRollingPolicy.setContext((Context)loggerContext);
        fwRollingPolicy.setFileNamePattern(logFilePath + "-%i.log.zip");
        fwRollingPolicy.setParent((FileAppender)rfAppender);
        fwRollingPolicy.start();
        SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
        triggeringPolicy.setMaxFileSize(FileSize.valueOf((String)"5 mb"));
        triggeringPolicy.start();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)loggerContext);
        if (fullStacktrace) {
            encoder.setPattern("%d{HH:mm:ss.SSS} [%thread] %highlight(%-5level) %logger{36} - %msg%n %throwable{full}");
        } else {
            encoder.setPattern("%d{HH:mm:ss.SSS} [%thread] %highlight(%-5level) %logger{36} - %msg%n %throwable{short}");
        }
        encoder.start();
        rfAppender.setEncoder((Encoder)encoder);
        rfAppender.setName("ROLLINGFILE");
        rfAppender.setRollingPolicy((RollingPolicy)fwRollingPolicy);
        rfAppender.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy);
        rfAppender.start();
        AsyncAppender asyncAppender = new AsyncAppender();
        asyncAppender.setContext((Context)loggerContext);
        asyncAppender.setName("ASYNC");
        asyncAppender.setQueueSize(1024);
        asyncAppender.setMaxFlushTime(5000);
        asyncAppender.addAppender((Appender)rfAppender);
        asyncAppender.start();
        rootLogger.addAppender((Appender)asyncAppender);
    }

    public static void stopLogging() {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        root.getLoggerContext().stop();
    }

    private LoggingInitializer() {
    }
}

