/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers;

import io.undertow.server.HttpServerExchange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.restheart.exchange.Exchange;
import org.restheart.exchange.Request;
import org.restheart.exchange.Response;
import org.restheart.exchange.UninitializedRequest;
import org.restheart.exchange.UninitializedResponse;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.Interceptor;
import org.restheart.plugins.InterceptorException;
import org.restheart.plugins.Plugin;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.PluginsRegistryImpl;
import org.restheart.plugins.Service;
import org.restheart.plugins.WildcardInterceptor;
import org.restheart.utils.LambdaUtils;
import org.restheart.utils.PluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeforeExchangeInitInterceptorsExecutor
extends PipelinedHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeforeExchangeInitInterceptorsExecutor.class);
    private ArrayList<WildcardInterceptor> wildCardInterceptors = new ArrayList();
    private ArrayList<WildcardInterceptor> requiredWildCardInterceptors = new ArrayList();
    private final PluginsRegistry pluginsRegistry = PluginsRegistryImpl.getInstance();

    public BeforeExchangeInitInterceptorsExecutor() {
        this(null);
    }

    public BeforeExchangeInitInterceptorsExecutor(PipelinedHandler next) {
        super(next);
        this.wildCardInterceptors = this.pluginsRegistry.getInterceptors().stream().filter(pr -> pr.isEnabled()).map(pr -> (Interceptor)pr.getInstance()).filter(i -> PluginUtils.interceptPoint((Interceptor)i) == InterceptPoint.REQUEST_BEFORE_EXCHANGE_INIT).filter(i -> i instanceof WildcardInterceptor).map(i -> (WildcardInterceptor)i).collect(Collectors.toCollection(ArrayList::new));
        this.requiredWildCardInterceptors = this.wildCardInterceptors.stream().filter(i -> PluginUtils.requiredinterceptor((Interceptor)i)).map(i -> i).collect(Collectors.toCollection(ArrayList::new));
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        UninitializedResponse response;
        UninitializedRequest request;
        ArrayList<WildcardInterceptor> interceptors;
        block4: {
            block5: {
                if (this.wildCardInterceptors.isEmpty()) {
                    this.next(exchange);
                    return;
                }
                interceptors = this.wildCardInterceptors;
                request = UninitializedRequest.of((HttpServerExchange)exchange);
                response = UninitializedResponse.of((HttpServerExchange)exchange);
                Service handlingPlugin = PluginUtils.handlingService((PluginsRegistry)this.pluginsRegistry, (HttpServerExchange)exchange);
                if (handlingPlugin == null) break block4;
                InterceptPoint[] vip = PluginUtils.dontIntercept((Service)handlingPlugin);
                if (Arrays.stream(vip).anyMatch(arg_0 -> InterceptPoint.REQUEST_BEFORE_EXCHANGE_INIT.equals(arg_0))) break block5;
                if (!Arrays.stream(vip).anyMatch(arg_0 -> InterceptPoint.ANY.equals(arg_0))) break block4;
            }
            interceptors = this.requiredWildCardInterceptors;
        }
        interceptors.stream().filter(ri -> {
            try {
                return ri.resolve((Request)request, (Response)response);
            }
            catch (Exception ex) {
                LOGGER.warn("Error resolving interceptor {} for {} on intercept point {}", new Object[]{ri.getClass().getSimpleName(), exchange.getRequestPath(), InterceptPoint.REQUEST_BEFORE_EXCHANGE_INIT, ex});
                Exchange.setInError((HttpServerExchange)exchange);
                LambdaUtils.throwsSneakyException((Throwable)new InterceptorException("Error resolving interceptor " + ri.getClass().getSimpleName(), (Throwable)ex));
                return false;
            }
        }).forEachOrdered(ri -> {
            try {
                LOGGER.debug("Executing interceptor {} for {} on intercept point {}", new Object[]{PluginUtils.name((Plugin)ri), exchange.getRequestPath(), InterceptPoint.REQUEST_BEFORE_EXCHANGE_INIT});
                ri.handle((Request)request, (Response)response);
            }
            catch (Exception ex) {
                LOGGER.error("Error executing interceptor {} for {} on intercept point {}", new Object[]{PluginUtils.name((Plugin)ri), exchange.getRequestPath(), InterceptPoint.REQUEST_BEFORE_EXCHANGE_INIT, ex});
                Exchange.setInError((HttpServerExchange)exchange);
                LambdaUtils.throwsSneakyException((Throwable)new InterceptorException("Error executing interceptor " + ri.getClass().getSimpleName(), (Throwable)ex));
            }
        });
        this.next(exchange);
    }
}

