/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.ServerFixedLengthStreamSinkConduit;
import io.undertow.util.Headers;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.restheart.exchange.ByteArrayProxyResponse;
import org.restheart.exchange.Exchange;
import org.restheart.exchange.ProxyResponse;
import org.restheart.handlers.ResponseInterceptorsExecutor;
import org.restheart.utils.BuffersUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

public class ModifiableContentSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    static final Logger LOGGER = LoggerFactory.getLogger(ModifiableContentSinkConduit.class);
    private final HttpServerExchange exchange;
    private final ResponseInterceptorsExecutor interceptorsExecutor;

    public ModifiableContentSinkConduit(StreamSinkConduit next, HttpServerExchange exchange) {
        super(next);
        this.exchange = exchange;
        this.interceptorsExecutor = new ResponseInterceptorsExecutor();
        this.resetBufferPool(exchange);
    }

    private void resetBufferPool(HttpServerExchange exchange) {
        PooledByteBuffer[] oldBuffers = (PooledByteBuffer[])exchange.getAttachment(ProxyResponse.BUFFERED_RESPONSE_DATA_KEY);
        if (oldBuffers != null) {
            for (PooledByteBuffer oldBuffer : oldBuffers) {
                if (oldBuffer == null) continue;
                oldBuffer.close();
            }
        }
        exchange.putAttachment(ProxyResponse.BUFFERED_RESPONSE_DATA_KEY, (Object)new PooledByteBuffer[Exchange.MAX_BUFFERS]);
    }

    public int write(ByteBuffer src) throws IOException {
        return BuffersUtils.append((ByteBuffer)src, (PooledByteBuffer[])((PooledByteBuffer[])this.exchange.getAttachment(ProxyResponse.BUFFERED_RESPONSE_DATA_KEY)), (HttpServerExchange)this.exchange);
    }

    public long write(ByteBuffer[] dsts, int offs, int len) throws IOException {
        for (int i = offs; i < len; ++i) {
            if (!dsts[i].hasRemaining()) continue;
            return this.write(dsts[i]);
        }
        return 0L;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer)src);
    }

    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer[])srcs, (int)offset, (int)length);
    }

    public void terminateWrites() throws IOException {
        try {
            this.interceptorsExecutor.handleRequest(this.exchange);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        PooledByteBuffer[] dests = ByteArrayProxyResponse.of((HttpServerExchange)this.exchange).getBuffer();
        this.updateContentLenght(this.exchange, dests);
        for (PooledByteBuffer dest : dests) {
            if (dest == null) continue;
            ((StreamSinkConduit)this.next).write(dest.getBuffer());
        }
        ((StreamSinkConduit)this.next).terminateWrites();
    }

    private void updateContentLenght(HttpServerExchange exchange, PooledByteBuffer[] dests) {
        long length = 0L;
        for (PooledByteBuffer dest : dests) {
            if (dest == null) continue;
            length += (long)dest.getBuffer().limit();
        }
        exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, length);
        if (this.next instanceof ServerFixedLengthStreamSinkConduit) {
            Method m;
            try {
                m = ServerFixedLengthStreamSinkConduit.class.getDeclaredMethod("reset", Long.TYPE, HttpServerExchange.class);
                m.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                LOGGER.error("could not find ServerFixedLengthStreamSinkConduit.reset method", (Throwable)ex);
                throw new RuntimeException("could not find ServerFixedLengthStreamSinkConduit.reset method", ex);
            }
            try {
                m.invoke((Object)this.next, length, exchange);
            }
            catch (Throwable ex) {
                LOGGER.error("could not access BUFFERED_REQUEST_DATA field", ex);
                throw new RuntimeException("could not access BUFFERED_REQUEST_DATA field", ex);
            }
        }
        LOGGER.warn("updateContentLenght() next is {}", (Object)((StreamSinkConduit)this.next).getClass().getSimpleName());
    }
}

