/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.Optional;
import java.util.function.Consumer;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.restheart.exchange.BadRequestException;
import org.restheart.exchange.PipelineInfo;
import org.restheart.exchange.UninitializedRequest;
import org.restheart.exchange.UninitializedResponse;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.PluginsRegistryImpl;
import org.restheart.plugins.Service;
import org.restheart.utils.BsonUtils;
import org.restheart.utils.HttpStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceExchangeInitializer
extends PipelinedHandler {
    private final Logger LOGGER = LoggerFactory.getLogger(ServiceExchangeInitializer.class);
    private final PluginsRegistry pluginsRegistry = PluginsRegistryImpl.getInstance();

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String path = exchange.getRequestPath();
        PipelineInfo pi = this.pluginsRegistry.getPipelineInfo(path);
        Optional<PluginRecord> srv = this.pluginsRegistry.getServices().stream().filter(s -> s.getName().equals(pi.getName())).findAny();
        if (srv.isPresent()) {
            try {
                Consumer customRequestInitializer = UninitializedRequest.of((HttpServerExchange)exchange).customRequestInitializer();
                if (customRequestInitializer == null) {
                    ((Service)srv.get().getInstance()).requestInitializer().accept(exchange);
                } else {
                    customRequestInitializer.accept(exchange);
                }
                Consumer customResponseInitializer = UninitializedResponse.of((HttpServerExchange)exchange).customResponseInitializer();
                if (customResponseInitializer == null) {
                    ((Service)srv.get().getInstance()).responseInitializer().accept(exchange);
                } else {
                    customResponseInitializer.accept(exchange);
                }
            }
            catch (BadRequestException bre) {
                this.LOGGER.debug("Error handling the request: {}", (Object)bre.getMessage(), (Object)bre);
                exchange.setStatusCode(bre.getStatusCode());
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, bre.contentType());
                exchange.getResponseSender().send(bre.isJsonMessage() ? bre.getMessage() : BsonUtils.toJson((BsonValue)this.getErrorDocument(bre.getStatusCode(), bre.getMessage())));
                return;
            }
            catch (Throwable t) {
                exchange.setStatusCode(500);
                throw t;
            }
        }
        this.next(exchange);
    }

    private BsonDocument getErrorDocument(int statusCode, String msg) {
        BsonDocument rep = new BsonDocument();
        rep.put("http status code", (BsonValue)new BsonInt32(statusCode));
        String text = HttpStatus.getStatusText((int)statusCode);
        if (text != null) {
            rep.put("http status description", (BsonValue)new BsonString(HttpStatus.getStatusText((int)statusCode)));
        }
        if (msg != null) {
            rep.put("message", (BsonValue)new BsonString(msg));
        }
        return rep;
    }
}

