/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.handlers;

import com.google.common.collect.Sets;
import io.undertow.server.HttpServerExchange;
import java.util.Set;
import java.util.stream.Collectors;
import org.restheart.exchange.Request;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.security.Authorizer;
import org.restheart.utils.PluginUtils;

public class AuthenticationConstraintHandler
extends PipelinedHandler {
    private final Set<Authorizer> allowers;

    public AuthenticationConstraintHandler(PipelinedHandler next, Set<PluginRecord<Authorizer>> authorizers) {
        super(next);
        this.allowers = authorizers == null ? Sets.newHashSet() : authorizers.stream().filter(a -> a.isEnabled()).filter(a -> a.getInstance() != null).map(a -> (Authorizer)a.getInstance()).filter(a -> PluginUtils.authorizerType((Authorizer)a) == Authorizer.TYPE.ALLOWER).collect(Collectors.toSet());
    }

    protected boolean isAuthenticationRequired(HttpServerExchange exchange) {
        return this.allowers.isEmpty() ? false : this.allowers.stream().allMatch(a -> a.isAuthenticationRequired(Request.of((HttpServerExchange)exchange)));
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.isAuthenticationRequired(exchange)) {
            exchange.getSecurityContext().setAuthenticationRequired();
        }
        this.next(exchange);
    }
}

