/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.utils;

import com.sun.akuma.Daemon;
import com.sun.akuma.JavaVMArguments;
import org.restheart.graal.ImageInfo;
import org.restheart.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTHeartDaemon
extends Daemon {
    private static final Logger LOGGER = LoggerFactory.getLogger(RESTHeartDaemon.class);

    public boolean isDaemonized() {
        return System.getProperty(RESTHeartDaemon.class.getName()) != null;
    }

    public void daemonize() {
        if (this.isDaemonized()) {
            throw new IllegalStateException("Already running as a daemon");
        }
        try {
            LOGGER.info("Forking...");
            JavaVMArguments args = JavaVMArguments.current();
            args.setSystemProperty(RESTHeartDaemon.class.getName(), "daemonized");
            String[] _args = (String[])args.toArray((Object[])new String[args.size()]);
            _args[0] = this.isExecutable() ? FileUtils.getFileAbsolutePath(_args[0]).toString() : RESTHeartDaemon.getCurrentExecutable();
            Process p = new ProcessBuilder(new String[0]).command(_args).start();
            LOGGER.info("Forked process: {}", (Object)p.pid());
            System.exit(0);
        }
        catch (Throwable t) {
            LOGGER.error("Fork failed", t);
            System.exit(-4);
        }
    }

    private boolean isExecutable() {
        try {
            return ImageInfo.isExecutable();
        }
        catch (Throwable cnfe) {
            return false;
        }
    }
}

