/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import org.restheart.metrics.MetricsService;
import org.restheart.plugins.Initializer;
import org.restheart.plugins.RegisterPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="jvmMetricsCollector", description="registers the JVM metrics", enabledByDefault=false)
public class JvmMetricsCollector
implements Initializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JvmMetricsCollector.class);

    public void init() {
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)(MetricsService.METRICS_REGISTRIES_PREFIX + "/jvm"));
        registry.registerAll("jvm mem", (MetricSet)new MemoryUsageGaugeSet());
        LOGGER.info("registered VM memory usage metrics");
        registry.registerAll("jvm garbage-collector", (MetricSet)new GarbageCollectorMetricSet());
        LOGGER.info("registered Garbage Collections metrics");
    }
}

