/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.metrics;

import com.codahale.metrics.SharedMetricRegistries;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import org.restheart.exchange.ServiceRequest;
import org.restheart.exchange.StringRequest;
import org.restheart.exchange.StringResponse;
import org.restheart.metrics.RHDropwizardExports;
import org.restheart.plugins.Inject;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.StringService;
import org.restheart.utils.BsonUtils;

@RegisterPlugin(name="metrics", description="returns requests metrics", secure=true, defaultURI="/metrics")
public class MetricsService
implements StringService {
    public static String METRICS_REGISTRIES_PREFIX = "METRICS-";
    @Inject(value="config")
    private Map<String, Object> config;
    private String serviceUri = "/metrics";

    @OnInit
    public void onInit() {
        this.serviceUri = (String)this.argOrDefault(this.config, "uri", "/metrics");
    }

    public void handle(StringRequest request, StringResponse response) throws IOException {
        if (request.isOptions()) {
            this.handleOptions((ServiceRequest)request);
            return;
        }
        if (!request.isGet()) {
            response.setStatusCode(405);
            return;
        }
        Map params = request.getPathParams(this.serviceUri.concat("/{*}"));
        if (!params.containsKey("*")) {
            BsonUtils.ArrayBuilder content = BsonUtils.array();
            SharedMetricRegistries.names().stream().filter(name -> name.startsWith(METRICS_REGISTRIES_PREFIX)).forEachOrdered(reg -> content.add(new String[]{reg.substring(METRICS_REGISTRIES_PREFIX.length())}));
            response.setContent((Object)content.toJson());
            response.setContentTypeAsJson();
        } else {
            String _pathTemplate = "/" + (String)params.get("*");
            Optional<String> pathTemplate = SharedMetricRegistries.names().stream().filter(METRICS_REGISTRIES_PREFIX.concat(_pathTemplate)::equals).findFirst();
            if (pathTemplate.isPresent()) {
                CollectorRegistry collector = new CollectorRegistry();
                collector.register((Collector)new RHDropwizardExports(pathTemplate.get()));
                StringWriter writer = new StringWriter();
                TextFormat.write004((Writer)writer, (Enumeration)collector.metricFamilySamples());
                response.setContent((Object)writer.toString());
            } else {
                response.setInError(404, "metric not found");
            }
        }
    }
}

