/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.PathTemplate;
import io.undertow.util.PathTemplateMatcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.restheart.exchange.ServiceRequest;
import org.restheart.exchange.ServiceResponse;
import org.restheart.metrics.MetricLabel;
import org.restheart.metrics.MetricNameAndLabels;
import org.restheart.metrics.Metrics;
import org.restheart.metrics.MetricsService;
import org.restheart.plugins.Inject;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.WildcardInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="requestsMetricsCollector", description="collects http requests metrics", interceptPoint=InterceptPoint.REQUEST_BEFORE_AUTH, enabledByDefault=false)
public class RequestsMetricsCollector
implements WildcardInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestsMetricsCollector.class);
    @Inject(value="config")
    private Map<String, Object> config;
    private final Set<PathTemplateMatcher<Boolean>> include = new HashSet<PathTemplateMatcher<Boolean>>();
    private final PathTemplateMatcher<Boolean> exclude = new PathTemplateMatcher();

    @OnInit
    public void onInit() {
        List _include = (List)this.argOrDefault(this.config, "include", new ArrayList());
        List _exclude = (List)this.argOrDefault(this.config, "exclude", new ArrayList());
        _include.stream().map(path -> {
            try {
                PathTemplate ret = PathTemplate.create((String)path);
                LOGGER.debug("Add include path {}", (Object)ret.getTemplateString());
                return ret;
            }
            catch (Throwable t) {
                LOGGER.warn("Wrong include path {}", path, (Object)t);
                return null;
            }
        }).filter(pathTemplate -> pathTemplate != null).forEach(pathTemplate -> {
            PathTemplateMatcher ptm = new PathTemplateMatcher();
            ptm.add(pathTemplate, (Object)true);
            this.include.add((PathTemplateMatcher<Boolean>)ptm);
        });
        _exclude.stream().map(path -> {
            try {
                PathTemplate ret = PathTemplate.create((String)path);
                LOGGER.debug("Add exclude path {}", (Object)ret.getTemplateString());
                return ret;
            }
            catch (Throwable t) {
                LOGGER.warn("Wrong exclude path {}", path, (Object)t);
                return null;
            }
        }).filter(pathTemplate -> pathTemplate != null).forEach(pathTemplate -> this.exclude.add(pathTemplate, (Object)true));
    }

    public void handle(ServiceRequest<?> request, ServiceResponse<?> response) throws Exception {
        HttpServerExchange exchange = request.getExchange();
        if (!exchange.isComplete()) {
            long startTime = System.currentTimeMillis();
            String uri = request.getPath();
            List matchedTemplates = this.include.stream().map(ptm -> ptm.match(uri)).filter(pmr -> pmr != null).collect(Collectors.toList());
            LOGGER.debug("Matched path templates {}", matchedTemplates.stream().map(t -> t.getMatchedTemplate()).collect(Collectors.toList()));
            try {
                exchange.addExchangeCompleteListener((httpServerExchange, nextListener) -> {
                    matchedTemplates.forEach(mt -> this.addMetrics((PathTemplateMatcher.PathMatchResult<Boolean>)mt, startTime, request, response));
                    nextListener.proceed();
                });
            }
            catch (Throwable t2) {
                LOGGER.warn("Error adding metric collector to request {} {}", new Object[]{request.getMethod(), request.getPath(), t2});
            }
        }
    }

    public boolean resolve(ServiceRequest<?> request, ServiceResponse<?> response) {
        String uri = request.getPath();
        boolean matchInclude = this.include.stream().anyMatch(ptm -> ptm.match(uri) != null);
        if (matchInclude) {
            PathTemplateMatcher.PathMatchResult matchExclude = this.exclude.match(uri);
            if (matchExclude != null && ((Boolean)matchExclude.getValue()).booleanValue()) {
                LOGGER.debug("Matched exclude path {}", (Object)matchExclude.getMatchedTemplate());
                LOGGER.debug("Return false since matched exclude path {}", (Object)matchExclude.getMatchedTemplate());
                return false;
            }
            LOGGER.debug("Return true since matched include paths");
            return true;
        }
        LOGGER.debug("Return false since did't match any include path");
        return false;
    }

    private void addMetrics(PathTemplateMatcher.PathMatchResult<Boolean> pathTemplate, long startTime, ServiceRequest<?> request, ServiceResponse<?> response) {
        String registyName = MetricsService.METRICS_REGISTRIES_PREFIX.concat(pathTemplate.getMatchedTemplate());
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)registyName);
        long duration = System.currentTimeMillis() - startTime;
        int _status = response.getStatusCode() > 0 ? response.getStatusCode() : 200;
        MetricLabel status = new MetricLabel("response_status_code", "" + _status);
        MetricLabel method = new MetricLabel("request_method", request.getMethod().toString());
        MetricLabel matchedTemplate = new MetricLabel("path_template", pathTemplate.getMatchedTemplate());
        List matchParams = pathTemplate.getParameters().entrySet().stream().filter(p -> !((String)p.getKey()).equals("*")).sorted().map(param -> new MetricLabel("path_template_param_".concat((String)param.getKey()), (String)param.getValue())).collect(Collectors.toList());
        ArrayList t1wp = new ArrayList();
        t1wp.addAll(MetricLabel.collect((MetricLabel[])new MetricLabel[]{method, matchedTemplate, status}));
        t1wp.addAll(matchParams);
        List customLabels = Metrics.getMetricLabels(request);
        if (customLabels != null) {
            t1wp.addAll(customLabels);
        }
        registry.timer(new MetricNameAndLabels("http_requests", t1wp).toString()).update(duration, TimeUnit.MILLISECONDS);
    }
}

