/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.mongodb;

import com.mongodb.Block;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import java.net.UnknownHostException;
import java.util.Properties;
import org.restheart.mongodb.MongoClientSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoReactiveClientSingleton {
    private static boolean initialized = false;
    private static ConnectionString mongoUri;
    private static final Logger LOGGER;
    private MongoClient mongoClient;

    public static void init(ConnectionString uri) {
        mongoUri = uri;
        initialized = uri != null;
    }

    public static MongoReactiveClientSingleton get() {
        return MongoReactiveClientSingleton.getInstance();
    }

    public static MongoReactiveClientSingleton getInstance() {
        return MongoDBClientSingletonHolder.INSTANCE;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    private MongoReactiveClientSingleton() {
        if (!initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            this.setup();
        }
        catch (UnknownHostException ex) {
            LOGGER.error("error initializing reactive mongodb client", (Throwable)ex);
        }
        catch (Throwable tr) {
            LOGGER.error("error initializing reactive mongodb client", tr);
        }
    }

    private void setup() throws UnknownHostException {
        if (MongoReactiveClientSingleton.isInitialized()) {
            MongoClientSettings settings = MongoClientSettings.builder().applyToConnectionPoolSettings((Block)new Block<ConnectionPoolSettings.Builder>(){

                public void apply(ConnectionPoolSettings.Builder builder) {
                    builder.minSize(0).maxSize(128);
                }
            }).applicationName("restheart (reactivestreams)").applyConnectionString(mongoUri).build();
            this.mongoClient = MongoClients.create((MongoClientSettings)settings);
        }
    }

    public MongoClient client() {
        return this.getClient();
    }

    public MongoClient getClient() {
        if (this.mongoClient == null) {
            throw new IllegalStateException("mongo client not initialized");
        }
        return this.mongoClient;
    }

    static {
        LOGGER = LoggerFactory.getLogger(MongoReactiveClientSingleton.class);
    }

    private static class MongoDBClientSingletonHolder {
        private static final MongoReactiveClientSingleton INSTANCE;

        private MongoDBClientSingletonHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            synchronized (classLoader) {
                Properties sysProps = System.getProperties();
                MongoReactiveClientSingleton singleton = (MongoReactiveClientSingleton)sysProps.get(MongoReactiveClientSingleton.class.getName());
                if (singleton != null) {
                    INSTANCE = singleton;
                } else {
                    INSTANCE = new MongoReactiveClientSingleton();
                    System.getProperties().put(MongoClientSingleton.class.getName(), INSTANCE);
                }
            }
        }
    }
}

