/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.mongodb;

import com.mongodb.Block;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.connection.ConnectionPoolSettings;
import java.util.Properties;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.fusesource.jansi.Ansi;
import org.restheart.mongodb.ConnectionChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoClientSingleton {
    private static boolean initialized = false;
    private static ConnectionString mongoUri;
    private String serverVersion = null;
    private static final Logger LOGGER;
    private MongoClient mclient;

    public static void init(ConnectionString uri) {
        mongoUri = uri;
        initialized = true;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static MongoClientSingleton get() {
        return MongoClientSingleton.getInstance();
    }

    public static MongoClientSingleton getInstance() {
        return MongoClientSingletonHolder.INSTANCE;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    private MongoClientSingleton() {
        if (!initialized) {
            throw new IllegalStateException("not initialized");
        }
    }

    private void setup() {
        block8: {
            if (!initialized) {
                throw new IllegalStateException("MongoClientSingleton is not initialized");
            }
            LOGGER.info("Connecting to MongoDB...");
            MongoClientSettings settings = MongoClientSettings.builder().applyToConnectionPoolSettings((Block)new Block<ConnectionPoolSettings.Builder>(){

                public void apply(ConnectionPoolSettings.Builder builder) {
                    builder.minSize(0).maxSize(128);
                }
            }).applicationName("restheart (sync)").applyConnectionString(mongoUri).build();
            this.mclient = MongoClients.create((MongoClientSettings)settings);
            if (ConnectionChecker.connected((MongoClient)this.mclient)) {
                try {
                    Document res = this.mclient.getDatabase("admin").runCommand((Bson)new BsonDocument("buildInfo", (BsonValue)new BsonInt32(1)));
                    Object _version = res.get((Object)"version");
                    if (_version != null && _version instanceof String) {
                        this.serverVersion = (String)_version;
                    } else {
                        LOGGER.warn("Cannot get the MongoDB version.");
                        this.serverVersion = "?";
                    }
                    LOGGER.info("MongoDB version {}", (Object)Ansi.ansi().fg(Ansi.Color.MAGENTA).a(this.getServerVersion()).reset().toString());
                    if (ConnectionChecker.replicaSet((MongoClient)this.mclient)) {
                        LOGGER.info("MongoDB is a replica set.");
                        break block8;
                    }
                    LOGGER.warn("MongoDB is a standalone instance.");
                }
                catch (Throwable t) {
                    LOGGER.error(Ansi.ansi().fg(Ansi.Color.RED).bold().a("Cannot connect to MongoDB. ").reset().toString() + "Check that MongoDB is running and the configuration property '/mclient/connection-string' is set properly");
                    this.serverVersion = "?";
                }
            } else {
                LOGGER.error(Ansi.ansi().fg(Ansi.Color.RED).bold().a("Cannot connect to MongoDB. ").reset().toString() + "Check that MongoDB is running and the configuration property '/mclient/connection-string' is set properly");
                this.serverVersion = "?";
            }
        }
    }

    public MongoClient client() {
        return this.getClient();
    }

    public MongoClient getClient() {
        if (!initialized) {
            throw new IllegalStateException("MongoClientSingleton is not initialized");
        }
        if (this.mclient == null) {
            this.setup();
        }
        return this.mclient;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    static {
        LOGGER = LoggerFactory.getLogger(MongoClientSingleton.class);
    }

    private static class MongoClientSingletonHolder {
        private static final MongoClientSingleton INSTANCE;

        private MongoClientSingletonHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            synchronized (classLoader) {
                Properties sysProps = System.getProperties();
                MongoClientSingleton singleton = (MongoClientSingleton)sysProps.get(MongoClientSingleton.class.getName());
                if (singleton != null) {
                    INSTANCE = singleton;
                } else {
                    INSTANCE = new MongoClientSingleton();
                    System.getProperties().put(MongoClientSingleton.class.getName(), INSTANCE);
                }
            }
        }
    }
}

