/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import java.util.Map;
import org.restheart.mongodb.MongoClientSingleton;
import org.restheart.plugins.Inject;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.Provider;
import org.restheart.plugins.RegisterPlugin;

@RegisterPlugin(name="mclient", description="provides the MongoClient", priority=11)
public class MongoClientProvider
implements Provider<MongoClient> {
    @Inject(value="config")
    private Map<String, Object> config;

    @OnInit
    public void init() {
        String mongoUri = (String)this.argOrDefault(this.config, "connection-string", "mongodb://127.0.0.1");
        ConnectionString mongoConnetion = new ConnectionString(mongoUri);
        MongoClientSingleton.init(mongoConnetion);
        MongoClientSingleton.getInstance().client();
    }

    public MongoClient get(PluginRecord<?> caller) {
        return MongoClientSingleton.get().client();
    }
}

