/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.initializers;

import io.undertow.server.HttpServerExchange;
import org.restheart.handlers.exchange.JsonRequest;
import org.restheart.plugins.Initializer;
import org.restheart.plugins.InjectPluginsRegistry;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.utils.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="testInitializer", priority=100, description="The initializer used to test interceptors and global predicates", enabledByDefault=false)
public class TestInitializer
implements Initializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestInitializer.class);
    private PluginsRegistry pluginRegistry;

    @InjectPluginsRegistry
    public void setPluginRegistry(PluginsRegistry pluginRegistry) {
        this.pluginRegistry = pluginRegistry;
    }

    public void init() {
        LOGGER.info("Testing initializer");
        LOGGER.info("\tdenies GET /secho/foo using a Global Permission Predicate");
        LOGGER.info("\tadds a request and a response interceptors for /iecho and /siecho");
        this.pluginRegistry.getGlobalSecurityPredicates().add(exchange -> {
            JsonRequest request = JsonRequest.wrap((HttpServerExchange)exchange);
            return !request.isGet() || !"/secho/foo".equals(URLUtils.removeTrailingSlashes((String)exchange.getRequestPath()));
        });
    }
}

