/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.interceptors;

import io.undertow.server.HttpServerExchange;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.Interceptor;
import org.restheart.plugins.RegisterPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="echoExampleAsyncResponseInterceptor", description="used for testing purposes", enabledByDefault=false, requiresContent=true, interceptPoint=InterceptPoint.RESPONSE_ASYNC)
public class EchoExampleAsyncResponseInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EchoExampleAsyncResponseInterceptor.class);

    public void handle(HttpServerExchange exchange) throws Exception {
        try {
            Thread.sleep(2000L);
            LOGGER.info("This log message is written 2 seconds after response by echoExampleAsyncResponseInterceptor");
        }
        catch (InterruptedException ie) {
            LOGGER.warn("error ", (Throwable)ie);
        }
    }

    public boolean resolve(HttpServerExchange exchange) {
        return exchange.getRequestPath().equals("/iecho") || exchange.getRequestPath().equals("/piecho") || exchange.getRequestPath().equals("/anything");
    }
}

