/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.interceptors;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.undertow.server.HttpServerExchange;
import java.util.LinkedList;
import org.restheart.handlers.exchange.JsonRequest;
import org.restheart.plugins.Interceptor;
import org.restheart.plugins.RegisterPlugin;

@RegisterPlugin(name="echoExampleRequestInterceptor", description="used for testing purposes", enabledByDefault=false, requiresContent=true)
public class EchoExampleRequestInterceptor
implements Interceptor {
    public void handle(HttpServerExchange exchange) throws Exception {
        JsonElement requestContent;
        LinkedList<String> vals = new LinkedList<String>();
        vals.add("param added by EchoExampleRequestInterceptor");
        exchange.getQueryParameters().put("param", vals);
        JsonRequest request = JsonRequest.wrap((HttpServerExchange)exchange);
        if (!request.isContentAvailable()) {
            request.writeContent((JsonElement)new JsonObject());
        }
        if (request.isContentTypeJson() && (requestContent = request.readContent()).isJsonObject()) {
            requestContent.getAsJsonObject().addProperty("prop1", "property added by EchoExampleRequestInterceptor");
            request.writeContent(requestContent);
        }
    }

    public boolean resolve(HttpServerExchange exchange) {
        return exchange.getRequestPath().equals("/iecho") || exchange.getRequestPath().equals("/anything");
    }
}

