/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.interceptors;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.Map;
import org.restheart.handlers.exchange.JsonResponse;
import org.restheart.plugins.InjectConfiguration;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.Interceptor;
import org.restheart.plugins.RegisterPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="echoExampleResponseInterceptor", description="used for testing purposes", enabledByDefault=false, requiresContent=true, interceptPoint=InterceptPoint.RESPONSE)
public class EchoExampleResponseInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EchoExampleResponseInterceptor.class);

    @InjectConfiguration
    public void init(Map<String, Object> args) {
        LOGGER.trace("got args {}", args);
    }

    public void handle(HttpServerExchange exchange) throws Exception {
        JsonElement _content;
        JsonResponse response = JsonResponse.wrap((HttpServerExchange)exchange);
        exchange.getResponseHeaders().add(HttpString.tryFromString((String)"header"), "added by EchoExampleResponseInterceptor " + exchange.getRequestPath());
        if (response.isContentAvailable() && (_content = response.readContent()).isJsonObject()) {
            JsonObject content = _content.getAsJsonObject();
            content.addProperty("prop2", "property added by EchoExampleResponseInterceptor");
            response.writeContent((JsonElement)content);
        }
    }

    public boolean resolve(HttpServerExchange exchange) {
        return exchange.getRequestPath().equals("/iecho") || exchange.getRequestPath().equals("/piecho") || exchange.getRequestPath().equals("/anything");
    }
}

