/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.interceptors;

import com.google.gson.JsonElement;
import io.undertow.server.HttpServerExchange;
import java.util.ArrayList;
import org.restheart.handlers.exchange.ByteArrayRequest;
import org.restheart.handlers.exchange.ByteArrayResponse;
import org.restheart.handlers.exchange.JsonRequest;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.Interceptor;
import org.restheart.plugins.RegisterPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="secretHider", description="forbis write requests on '/coll' containing the property 'secret' to users does not have the role 'admin'", enabledByDefault=false, interceptPoint=InterceptPoint.REQUEST_AFTER_AUTH)
public class SecretHider
implements Interceptor {
    static final Logger LOGGER = LoggerFactory.getLogger(SecretHider.class);

    public void handle(HttpServerExchange hse) throws Exception {
        JsonElement content = JsonRequest.wrap((HttpServerExchange)hse).readContent();
        if (this.keys(content).stream().anyMatch(k -> "secret".equals(k) || k.endsWith(".secret"))) {
            ByteArrayResponse response = ByteArrayResponse.wrap((HttpServerExchange)hse);
            response.endExchangeWithMessage(403, "cannot write secret");
        }
    }

    public boolean resolve(HttpServerExchange hse) {
        ByteArrayRequest req = ByteArrayRequest.wrap((HttpServerExchange)hse);
        return ByteArrayRequest.isContentTypeJson((HttpServerExchange)hse) && !req.isAccountInRole("admin") && hse.getRequestPath().startsWith("/coll") && (req.isPost() || req.isPatch() || req.isPut());
    }

    private ArrayList<String> keys(JsonElement val) {
        ArrayList<String> keys = new ArrayList<String>();
        if (val == null) {
            return keys;
        }
        if (val.isJsonObject()) {
            val.getAsJsonObject().keySet().forEach(k -> {
                keys.add((String)k);
                keys.addAll(this.keys(val.getAsJsonObject().get(k)));
            });
        } else if (val.isJsonArray()) {
            val.getAsJsonArray().forEach(v -> keys.addAll(this.keys((JsonElement)v)));
        }
        return keys;
    }
}

