/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.interceptors;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.Interceptor;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.TokenManager;

@RegisterPlugin(name="tokenCORSResponseInterceptor", description="helper interceptor to add token headers to Access-Control-Expose-Headers to handle CORS request", interceptPoint=InterceptPoint.RESPONSE, enabledByDefault=true)
public class TokenCORSResponseInterceptor
implements Interceptor {
    private String[] headers;

    public TokenCORSResponseInterceptor() {
        this.headers = new String[0];
    }

    public TokenCORSResponseInterceptor(String ... headers) {
        this.headers = headers;
    }

    public void handle(HttpServerExchange exchange) throws Exception {
        HeaderValues hs = exchange.getResponseHeaders().get(TokenManager.ACCESS_CONTROL_EXPOSE_HEADERS);
        if (hs == null || hs.isEmpty()) {
            exchange.getResponseHeaders().put(TokenManager.ACCESS_CONTROL_EXPOSE_HEADERS, this.headers());
        } else {
            String v0 = hs.getFirst();
            for (String h : this.headers) {
                if (v0.contains(h)) continue;
                v0 = v0.concat(", ").concat(h);
            }
            exchange.getResponseHeaders().put(TokenManager.ACCESS_CONTROL_EXPOSE_HEADERS, v0);
        }
    }

    public boolean resolve(HttpServerExchange exchange) {
        return true;
    }

    private String headers() {
        String ret = "";
        boolean first = true;
        for (String h : this.headers) {
            if (first) {
                ret = ret.concat(h);
                first = false;
                continue;
            }
            ret = ret.concat(", ").concat(h);
        }
        return ret;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
    }
}

