/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.services;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.restheart.handlers.exchange.ByteArrayRequest;
import org.restheart.handlers.exchange.JsonRequest;
import org.restheart.handlers.exchange.JsonResponse;
import org.restheart.handlers.exchange.Request;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.Service;
import org.restheart.utils.BuffersUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="echo", description="echoes the request", enabledByDefault=true, defaultURI="/echo")
public class EchoService
implements Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(EchoService.class);

    public void handle(HttpServerExchange exchange) throws Exception {
        JsonRequest request;
        JsonObject resp = new JsonObject();
        resp.addProperty("method", exchange.getRequestMethod().toString());
        resp.addProperty("URL", exchange.getRequestURL());
        if (Request.isContentTypeJson((HttpServerExchange)exchange)) {
            request = JsonRequest.wrap((HttpServerExchange)exchange);
            try {
                resp.add("content", request.readContent());
            }
            catch (JsonSyntaxException jse) {
                resp.addProperty("content", this.getTruncatedContent(ByteArrayRequest.wrap((HttpServerExchange)exchange)));
                resp.addProperty("note", "showing up to 20 bytes of the request content");
            }
        } else {
            request = ByteArrayRequest.wrap((HttpServerExchange)exchange);
            if (request.isContentTypeXml() || request.isContentTypeText()) {
                resp.addProperty("content", BuffersUtils.toString((PooledByteBuffer[])request.getRawContent(), (Charset)Charset.forName("utf-8")));
            } else if (request.isContentAvailable()) {
                resp.addProperty("content", this.getTruncatedContent((ByteArrayRequest)request));
                resp.addProperty("note", "showing up to 20 bytes of the request content");
            }
        }
        JsonResponse response = JsonResponse.wrap((HttpServerExchange)exchange);
        response.setStatusCode(200);
        JsonObject qparams = new JsonObject();
        resp.add("qparams", (JsonElement)qparams);
        exchange.getQueryParameters().forEach((name, values) -> {
            JsonArray _values = new JsonArray();
            qparams.add(name, (JsonElement)_values);
            values.iterator().forEachRemaining(value -> _values.add(value));
        });
        JsonObject headers = new JsonObject();
        resp.add("headers", (JsonElement)headers);
        exchange.getRequestHeaders().forEach(header -> {
            JsonArray _values = new JsonArray();
            headers.add(header.getHeaderName().toString(), (JsonElement)_values);
            header.iterator().forEachRemaining(value -> _values.add(value));
        });
        response.writeContent((JsonElement)resp);
    }

    private String getTruncatedContent(ByteArrayRequest request) throws IOException {
        byte[] content = request.readContent();
        if (content == null) {
            return null;
        }
        if (content.length < 1024) {
            return new String(content, StandardCharsets.UTF_8);
        }
        return new String(Arrays.copyOfRange(content, 0, 1023), StandardCharsets.UTF_8);
    }
}

