/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.mechanisms;

import io.undertow.UndertowMessages;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.NonceManager;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.DigestAlgorithm;
import io.undertow.security.idm.DigestCredential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.DigestAuthorizationToken;
import io.undertow.security.impl.DigestQop;
import io.undertow.security.impl.SimpleNonceManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HexConverter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.restheart.ConfigurationException;
import org.restheart.handlers.QueryStringRebuilder;
import org.restheart.plugins.ConfigurablePlugin;
import org.restheart.plugins.InjectConfiguration;
import org.restheart.plugins.InjectPluginsRegistry;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.AuthMechanism;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="digestAuthMechanism", description="handles the digest authentication scheme", enabledByDefault=false)
public class DigestAuthMechanism
implements AuthMechanism {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigestAuthMechanism.class);
    public static final String SILENT_HEADER_KEY = "No-Auth-Challenge";
    public static final String SILENT_QUERY_PARAM_KEY = "noauthchallenge";
    private static final String DIGEST_PREFIX = Headers.DIGEST + " ";
    private static final int PREFIX_LENGTH = DIGEST_PREFIX.length();
    private static final String OPAQUE_VALUE = "00000000000000000000000000000000";
    private static final byte COLON = 58;
    private final String mechanismName;
    private IdentityManager identityManager;
    private static final Set<DigestAuthorizationToken> MANDATORY_REQUEST_TOKENS;
    private final List<DigestAlgorithm> supportedAlgorithms;
    private final List<DigestQop> supportedQops;
    private final String qopString;
    private String realmName;
    private String domain;
    private final NonceManager nonceManager;

    public DigestAuthMechanism() throws ConfigurationException {
        this("RESTHeart Realm", "localhost", "digestAuthMechanism", null);
    }

    @InjectConfiguration
    @InjectPluginsRegistry
    public void init(Map<String, Object> args, PluginsRegistry pluginsRegistry) throws ConfigurationException {
        this.realmName = (String)ConfigurablePlugin.argValue(args, (String)"realm");
        this.domain = (String)ConfigurablePlugin.argValue(args, (String)"domain");
        this.identityManager = (IdentityManager)pluginsRegistry.getAuthenticator((String)ConfigurablePlugin.argValue(args, (String)"authenticator")).getInstance();
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        if (exchange.getRequestHeaders().contains(SILENT_HEADER_KEY) || exchange.getQueryParameters().containsKey(SILENT_QUERY_PARAM_KEY)) {
            return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(401));
        }
        return this._sendChallenge(exchange, securityContext);
    }

    public DigestAuthMechanism(String mechanismName, List<DigestAlgorithm> supportedAlgorithms, List<DigestQop> supportedQops, String realmName, String domain, NonceManager nonceManager) {
        this(supportedAlgorithms, supportedQops, realmName, domain, nonceManager, mechanismName);
    }

    public DigestAuthMechanism(List<DigestAlgorithm> supportedAlgorithms, List<DigestQop> supportedQops, String realmName, String domain, NonceManager nonceManager, String mechanismName) {
        this(supportedAlgorithms, supportedQops, realmName, domain, nonceManager, mechanismName, null);
    }

    public DigestAuthMechanism(List<DigestAlgorithm> supportedAlgorithms, List<DigestQop> supportedQops, String realmName, String domain, NonceManager nonceManager, String mechanismName, IdentityManager identityManager) {
        this.supportedAlgorithms = supportedAlgorithms;
        this.supportedQops = supportedQops;
        this.realmName = realmName;
        this.domain = domain;
        this.nonceManager = nonceManager;
        this.mechanismName = mechanismName;
        this.identityManager = identityManager;
        if (!supportedQops.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator<DigestQop> it = supportedQops.iterator();
            sb.append(it.next().getToken());
            while (it.hasNext()) {
                sb.append(",").append(it.next().getToken());
            }
            this.qopString = sb.toString();
        } else {
            this.qopString = null;
        }
    }

    public DigestAuthMechanism(String realmName, String domain, String mechanismName) {
        this(realmName, domain, mechanismName, null);
    }

    public DigestAuthMechanism(String realmName, String domain, String mechanismName, IdentityManager identityManager) {
        this(Collections.singletonList(DigestAlgorithm.MD5), Collections.singletonList(DigestQop.AUTH), realmName, domain, (NonceManager)new SimpleNonceManager(), mechanismName, identityManager);
    }

    private IdentityManager getIdentityManager(SecurityContext securityContext) {
        return this.identityManager != null ? this.identityManager : securityContext.getIdentityManager();
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        Iterator iterator;
        HeaderValues authHeaders = exchange.getRequestHeaders().get(Headers.AUTHORIZATION);
        if (authHeaders != null && (iterator = authHeaders.iterator()).hasNext()) {
            String current = (String)iterator.next();
            if (current.startsWith(DIGEST_PREFIX)) {
                String digestChallenge = current.substring(PREFIX_LENGTH);
                try {
                    DigestContext context = new DigestContext();
                    Map parsedHeader = DigestAuthorizationToken.parseHeader((String)digestChallenge);
                    context.setMethod(exchange.getRequestMethod().toString());
                    context.setParsedHeader(parsedHeader);
                    exchange.putAttachment(DigestContext.ATTACHMENT_KEY, (Object)context);
                    LOGGER.trace("Found digest header {} in {}", (Object)current, (Object)exchange);
                    return this.handleDigestHeader(exchange, securityContext);
                }
                catch (Exception e) {
                    LOGGER.debug("Error", (Throwable)e);
                }
            }
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    private AuthenticationMechanism.AuthenticationMechanismOutcome handleDigestHeader(HttpServerExchange exchange, SecurityContext securityContext) {
        DigestAlgorithm algorithm;
        DigestContext context = (DigestContext)exchange.getAttachment(DigestContext.ATTACHMENT_KEY);
        Map<DigestAuthorizationToken, String> parsedHeader = context.getParsedHeader();
        EnumSet<DigestAuthorizationToken> mandatoryTokens = EnumSet.copyOf(MANDATORY_REQUEST_TOKENS);
        if (!this.supportedAlgorithms.contains(DigestAlgorithm.MD5)) {
            mandatoryTokens.add(DigestAuthorizationToken.ALGORITHM);
        }
        if (!this.supportedQops.isEmpty() && !this.supportedQops.contains(DigestQop.AUTH)) {
            mandatoryTokens.add(DigestAuthorizationToken.MESSAGE_QOP);
        }
        if (parsedHeader.containsKey(DigestAuthorizationToken.MESSAGE_QOP)) {
            DigestQop qop = DigestQop.forName((String)parsedHeader.get(DigestAuthorizationToken.MESSAGE_QOP));
            if (qop == null || !this.supportedQops.contains(qop)) {
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            context.setQop(qop);
            mandatoryTokens.add(DigestAuthorizationToken.CNONCE);
            mandatoryTokens.add(DigestAuthorizationToken.NONCE_COUNT);
        }
        mandatoryTokens.removeAll(parsedHeader.keySet());
        if (mandatoryTokens.size() > 0) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (!this.realmName.equals(parsedHeader.get(DigestAuthorizationToken.REALM))) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (parsedHeader.containsKey(DigestAuthorizationToken.DIGEST_URI)) {
            String uri = parsedHeader.get(DigestAuthorizationToken.DIGEST_URI);
            Object requestURI = exchange.getRequestURI();
            String originalQueryString = QueryStringRebuilder.getOriginalQueryString((HttpServerExchange)exchange);
            if (!originalQueryString.isEmpty()) {
                requestURI = (String)requestURI + "?" + originalQueryString;
            }
            if (!uri.equals(requestURI)) {
                requestURI = exchange.getRequestURL();
                if (!exchange.getQueryString().isEmpty()) {
                    requestURI = (String)requestURI + "?" + exchange.getQueryString();
                }
                if (!uri.equals(requestURI)) {
                    LOGGER.warn("The URI in digest token does not match the request URI");
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                }
            }
        } else {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (parsedHeader.containsKey(DigestAuthorizationToken.OPAQUE) && !OPAQUE_VALUE.equals(parsedHeader.get(DigestAuthorizationToken.OPAQUE))) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (parsedHeader.containsKey(DigestAuthorizationToken.ALGORITHM)) {
            algorithm = DigestAlgorithm.forName((String)parsedHeader.get(DigestAuthorizationToken.ALGORITHM));
            if (algorithm == null || !this.supportedAlgorithms.contains(algorithm)) {
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
        } else {
            algorithm = DigestAlgorithm.MD5;
        }
        try {
            context.setAlgorithm(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Error", (Throwable)e);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        String userName = parsedHeader.get(DigestAuthorizationToken.USERNAME);
        IdentityManager lidentityManager = this.getIdentityManager(securityContext);
        if (algorithm.isSession()) {
            throw new IllegalStateException("Not yet implemented.");
        }
        DigestCredentialImpl credential = new DigestCredentialImpl(context);
        Account account = lidentityManager.verify(userName, (Credential)credential);
        if (account == null) {
            securityContext.authenticationFailed(UndertowMessages.MESSAGES.authenticationFailed(userName), this.getMechanismName());
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        if (!this.validateNonceUse(context, parsedHeader, exchange)) {
            context.markStale();
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        this.sendAuthenticationInfoHeader(exchange);
        securityContext.authenticationComplete(account, this.getMechanismName(), false);
        return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
    }

    private boolean validateRequest(DigestContext context, byte[] ha1) {
        DigestQop qop = context.getQop();
        byte[] ha2 = qop == null || qop.equals((Object)DigestQop.AUTH) ? this.createHA2Auth(context, context.getParsedHeader()) : this.createHA2AuthInt();
        byte[] requestDigest = qop == null ? this.createRFC2069RequestDigest(ha1, ha2, context) : this.createRFC2617RequestDigest(ha1, ha2, context);
        byte[] providedResponse = context.getParsedHeader().get(DigestAuthorizationToken.RESPONSE).getBytes(StandardCharsets.UTF_8);
        return MessageDigest.isEqual(requestDigest, providedResponse);
    }

    private boolean validateNonceUse(DigestContext context, Map<DigestAuthorizationToken, String> parsedHeader, HttpServerExchange exchange) {
        String suppliedNonce = parsedHeader.get(DigestAuthorizationToken.NONCE);
        int nonceCount = -1;
        if (parsedHeader.containsKey(DigestAuthorizationToken.NONCE_COUNT)) {
            String nonceCountHex = parsedHeader.get(DigestAuthorizationToken.NONCE_COUNT);
            nonceCount = Integer.parseInt(nonceCountHex, 16);
        }
        context.setNonce(suppliedNonce);
        return this.nonceManager.validateNonce(suppliedNonce, nonceCount, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createHA2Auth(DigestContext context, Map<DigestAuthorizationToken, String> parsedHeader) {
        byte[] method = context.getMethod().getBytes(StandardCharsets.UTF_8);
        byte[] digestUri = parsedHeader.get(DigestAuthorizationToken.DIGEST_URI).getBytes(StandardCharsets.UTF_8);
        MessageDigest digest = context.getDigest();
        try {
            digest.update(method);
            digest.update((byte)58);
            digest.update(digestUri);
            byte[] byArray = HexConverter.convertToHexBytes((byte[])digest.digest());
            return byArray;
        }
        finally {
            digest.reset();
        }
    }

    private byte[] createHA2AuthInt() {
        throw new IllegalStateException("Method not implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createRFC2069RequestDigest(byte[] ha1, byte[] ha2, DigestContext context) {
        MessageDigest digest = context.getDigest();
        Map<DigestAuthorizationToken, String> parsedHeader = context.getParsedHeader();
        byte[] nonce = parsedHeader.get(DigestAuthorizationToken.NONCE).getBytes(StandardCharsets.UTF_8);
        try {
            digest.update(ha1);
            digest.update((byte)58);
            digest.update(nonce);
            digest.update((byte)58);
            digest.update(ha2);
            byte[] byArray = HexConverter.convertToHexBytes((byte[])digest.digest());
            return byArray;
        }
        finally {
            digest.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createRFC2617RequestDigest(byte[] ha1, byte[] ha2, DigestContext context) {
        MessageDigest digest = context.getDigest();
        Map<DigestAuthorizationToken, String> parsedHeader = context.getParsedHeader();
        byte[] nonce = parsedHeader.get(DigestAuthorizationToken.NONCE).getBytes(StandardCharsets.UTF_8);
        byte[] nonceCount = parsedHeader.get(DigestAuthorizationToken.NONCE_COUNT).getBytes(StandardCharsets.UTF_8);
        byte[] cnonce = parsedHeader.get(DigestAuthorizationToken.CNONCE).getBytes(StandardCharsets.UTF_8);
        byte[] qop = parsedHeader.get(DigestAuthorizationToken.MESSAGE_QOP).getBytes(StandardCharsets.UTF_8);
        try {
            digest.update(ha1);
            digest.update((byte)58);
            digest.update(nonce);
            digest.update((byte)58);
            digest.update(nonceCount);
            digest.update((byte)58);
            digest.update(cnonce);
            digest.update((byte)58);
            digest.update(qop);
            digest.update((byte)58);
            digest.update(ha2);
            byte[] byArray = HexConverter.convertToHexBytes((byte[])digest.digest());
            return byArray;
        }
        finally {
            digest.reset();
        }
    }

    private AuthenticationMechanism.ChallengeResult _sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        DigestContext context = (DigestContext)exchange.getAttachment(DigestContext.ATTACHMENT_KEY);
        boolean stale = context == null ? false : context.isStale();
        StringBuilder rb = new StringBuilder(DIGEST_PREFIX);
        rb.append(Headers.REALM.toString()).append("=\"").append(this.realmName).append("\",");
        rb.append(Headers.DOMAIN.toString()).append("=\"").append(this.domain).append("\",");
        rb.append(Headers.NONCE.toString()).append("=\"").append(this.nonceManager.nextNonce(null, exchange)).append("\",");
        rb.append(Headers.OPAQUE.toString()).append("=\"00000000000000000000000000000000\"");
        if (stale) {
            rb.append(",stale=true");
        }
        if (this.supportedAlgorithms.size() > 0) {
            rb.append(",").append(Headers.ALGORITHM.toString()).append("=%s");
        }
        if (this.qopString != null) {
            rb.append(",").append(Headers.QOP.toString()).append("=\"").append(this.qopString).append("\"");
        }
        String theChallenge = rb.toString();
        HeaderMap responseHeader = exchange.getResponseHeaders();
        if (this.supportedAlgorithms.isEmpty()) {
            responseHeader.add(Headers.WWW_AUTHENTICATE, theChallenge);
        } else {
            this.supportedAlgorithms.forEach(current -> responseHeader.add(Headers.WWW_AUTHENTICATE, String.format(theChallenge, current.getToken())));
        }
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(401));
    }

    public void sendAuthenticationInfoHeader(HttpServerExchange exchange) {
        DigestContext context = (DigestContext)exchange.getAttachment(DigestContext.ATTACHMENT_KEY);
        DigestQop qop = context.getQop();
        String currentNonce = context.getNonce();
        String nextNonce = this.nonceManager.nextNonce(currentNonce, exchange);
        if (qop != null || !nextNonce.equals(currentNonce)) {
            StringBuilder sb = new StringBuilder();
            sb.append(Headers.NEXT_NONCE).append("=\"").append(nextNonce).append("\"");
            if (qop != null) {
                Map<DigestAuthorizationToken, String> parsedHeader = context.getParsedHeader();
                sb.append(",").append(Headers.QOP.toString()).append("=\"").append(qop.getToken()).append("\"");
                byte[] ha1 = context.getHa1();
                byte[] ha2 = qop == DigestQop.AUTH ? this.createHA2Auth(context) : this.createHA2AuthInt();
                String rspauth = new String(this.createRFC2617RequestDigest(ha1, ha2, context), StandardCharsets.UTF_8);
                sb.append(",").append(Headers.RESPONSE_AUTH.toString()).append("=\"").append(rspauth).append("\"");
                sb.append(",").append(Headers.CNONCE.toString()).append("=\"").append(parsedHeader.get(DigestAuthorizationToken.CNONCE)).append("\"");
                sb.append(",").append(Headers.NONCE_COUNT.toString()).append("=").append(parsedHeader.get(DigestAuthorizationToken.NONCE_COUNT));
            }
            HeaderMap responseHeader = exchange.getResponseHeaders();
            responseHeader.add(Headers.AUTHENTICATION_INFO, sb.toString());
        }
        exchange.removeAttachment(DigestContext.ATTACHMENT_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createHA2Auth(DigestContext context) {
        byte[] digestUri = context.getParsedHeader().get(DigestAuthorizationToken.DIGEST_URI).getBytes(StandardCharsets.UTF_8);
        MessageDigest digest = context.getDigest();
        try {
            digest.update((byte)58);
            digest.update(digestUri);
            byte[] byArray = HexConverter.convertToHexBytes((byte[])digest.digest());
            return byArray;
        }
        finally {
            digest.reset();
        }
    }

    public String getMechanismName() {
        return this.mechanismName;
    }

    static {
        EnumSet<DigestAuthorizationToken> mandatoryTokens = EnumSet.noneOf(DigestAuthorizationToken.class);
        mandatoryTokens.add(DigestAuthorizationToken.USERNAME);
        mandatoryTokens.add(DigestAuthorizationToken.REALM);
        mandatoryTokens.add(DigestAuthorizationToken.NONCE);
        mandatoryTokens.add(DigestAuthorizationToken.DIGEST_URI);
        mandatoryTokens.add(DigestAuthorizationToken.RESPONSE);
        MANDATORY_REQUEST_TOKENS = Collections.unmodifiableSet(mandatoryTokens);
    }

    private class DigestCredentialImpl
    implements DigestCredential {
        private final DigestContext context;

        private DigestCredentialImpl(DigestContext digestContext) {
            this.context = digestContext;
        }

        public DigestAlgorithm getAlgorithm() {
            return this.context.getAlgorithm();
        }

        public boolean verifyHA1(byte[] ha1) {
            this.context.setHa1(ha1);
            return DigestAuthMechanism.this.validateRequest(this.context, ha1);
        }

        public String getRealm() {
            return DigestAuthMechanism.this.realmName;
        }

        public byte[] getSessionData() {
            if (!this.context.getAlgorithm().isSession()) {
                throw UndertowMessages.MESSAGES.noSessionData();
            }
            byte[] nonce = this.context.getParsedHeader().get(DigestAuthorizationToken.NONCE).getBytes(StandardCharsets.UTF_8);
            byte[] cnonce = this.context.getParsedHeader().get(DigestAuthorizationToken.CNONCE).getBytes(StandardCharsets.UTF_8);
            byte[] response = new byte[nonce.length + cnonce.length + 1];
            System.arraycopy(nonce, 0, response, 0, nonce.length);
            response[nonce.length] = 58;
            System.arraycopy(cnonce, 0, response, nonce.length + 1, cnonce.length);
            return response;
        }
    }

    private static class DigestContext {
        static final AttachmentKey<DigestContext> ATTACHMENT_KEY = AttachmentKey.create(DigestContext.class);
        private String method;
        private String nonce;
        private DigestQop qop;
        private byte[] ha1;
        private DigestAlgorithm algorithm;
        private MessageDigest digest;
        private boolean stale = false;
        Map<DigestAuthorizationToken, String> parsedHeader;

        private DigestContext() {
        }

        String getMethod() {
            return this.method;
        }

        void setMethod(String method) {
            this.method = method;
        }

        boolean isStale() {
            return this.stale;
        }

        void markStale() {
            this.stale = true;
        }

        String getNonce() {
            return this.nonce;
        }

        void setNonce(String nonce) {
            this.nonce = nonce;
        }

        DigestQop getQop() {
            return this.qop;
        }

        void setQop(DigestQop qop) {
            this.qop = qop;
        }

        byte[] getHa1() {
            return this.ha1;
        }

        void setHa1(byte[] ha1) {
            this.ha1 = ha1;
        }

        DigestAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        void setAlgorithm(DigestAlgorithm algorithm) throws NoSuchAlgorithmException {
            this.algorithm = algorithm;
            this.digest = algorithm.getMessageDigest();
        }

        MessageDigest getDigest() {
            return this.digest;
        }

        Map<DigestAuthorizationToken, String> getParsedHeader() {
            return this.parsedHeader;
        }

        void setParsedHeader(Map<DigestAuthorizationToken, String> parsedHeader) {
            this.parsedHeader = parsedHeader;
        }
    }
}

