/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.authorizers;

import com.google.common.collect.Sets;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateParser;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import java.io.FileNotFoundException;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.restheart.ConfigurationException;
import org.restheart.exchange.BufferedByteArrayRequest;
import org.restheart.plugins.ConfigurablePlugin;
import org.restheart.plugins.FileConfigurablePlugin;
import org.restheart.plugins.InjectConfiguration;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.Authorizer;
import org.restheart.utils.LambdaUtils;

@RegisterPlugin(name="requestPredicatesAuthorizer", description="authorizes requests according to acl defined in a configuration file", enabledByDefault=false)
public class RequestPredicatesAuthorizer
extends FileConfigurablePlugin
implements Authorizer {
    private final HashMap<String, Set<Predicate>> acl = new HashMap();

    @InjectConfiguration
    public void init(Map<String, Object> confArgs) throws FileNotFoundException, ConfigurationException {
        this.init(confArgs, "permissions");
    }

    public Consumer<? super Map<String, Object>> consumeConfiguration() {
        return u -> {
            try {
                String role = (String)ConfigurablePlugin.argValue((Map)u, (String)"role");
                String _predicate = (String)ConfigurablePlugin.argValue((Map)u, (String)"predicate");
                Predicate predicate = null;
                try {
                    predicate = PredicateParser.parse((String)_predicate, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                }
                catch (Throwable t) {
                    throw new ConfigurationException("wrong configuration: Invalid predicate " + _predicate, t);
                }
                this.aclForRole(role).add(predicate);
            }
            catch (ConfigurationException pce) {
                LambdaUtils.throwsSneakyExcpetion((Throwable)pce);
            }
        };
    }

    public boolean isAllowed(HttpServerExchange exchange) {
        if (this.noAclDefined()) {
            return false;
        }
        if (exchange.getAttachment(Predicate.PREDICATE_CONTEXT) == null) {
            exchange.putAttachment(Predicate.PREDICATE_CONTEXT, new TreeMap());
        }
        exchange.setRelativePath(exchange.getRequestPath());
        return this.roles(exchange).anyMatch(role -> this.aclForRole((String)role).stream().anyMatch(p -> p.resolve(exchange)));
    }

    public boolean isAuthenticationRequired(HttpServerExchange exchange) {
        if (BufferedByteArrayRequest.of((HttpServerExchange)exchange).isOptions()) {
            return false;
        }
        if (this.getAcl() == null) {
            return true;
        }
        Set<Predicate> ps = this.getAcl().get("$unauthenticated");
        if (ps != null) {
            if (exchange.getAttachment(Predicate.PREDICATE_CONTEXT) == null) {
                exchange.putAttachment(Predicate.PREDICATE_CONTEXT, new TreeMap());
            }
            exchange.setRelativePath(exchange.getRequestPath());
            return !ps.stream().anyMatch(p -> p.resolve(exchange));
        }
        return true;
    }

    private Stream<String> roles(HttpServerExchange exchange) {
        return this.account(exchange).getRoles().stream();
    }

    private boolean noAclDefined() {
        return this.getAcl() == null;
    }

    private Set<Predicate> aclForRole(String role) {
        HashSet predicates = this.getAcl().get(role);
        if (predicates == null) {
            predicates = Sets.newHashSet();
            this.getAcl().put(role, predicates);
        }
        return predicates;
    }

    private Account account(HttpServerExchange exchange) {
        Account account = exchange.getSecurityContext().getAuthenticatedAccount();
        return this.isAuthenticated(account) ? account : new NotAuthenticatedAccount();
    }

    private boolean isAuthenticated(Account authenticatedAccount) {
        return authenticatedAccount != null;
    }

    public HashMap<String, Set<Predicate>> getAcl() {
        return this.acl;
    }

    private static class NotAuthenticatedAccount
    implements Account {
        private static final long serialVersionUID = 3124L;

        private NotAuthenticatedAccount() {
        }

        public Principal getPrincipal() {
            return null;
        }

        public Set<String> getRoles() {
            return Sets.newHashSet((Object[])new String[]{"$unauthenticated"});
        }
    }
}

