/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.authenticators;

import com.google.common.collect.Sets;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.DigestCredential;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.util.HexConverter;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.restheart.ConfigurationException;
import org.restheart.plugins.ConfigurablePlugin;
import org.restheart.plugins.FileConfigurablePlugin;
import org.restheart.plugins.InjectConfiguration;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.Authenticator;
import org.restheart.plugins.security.PwdCredentialAccount;
import org.restheart.utils.LambdaUtils;

@RegisterPlugin(name="simpleFileAuthenticator", description="authenticates clients credentials defined in a configuration file", enabledByDefault=false)
public class SimpleFileAuthenticator
extends FileConfigurablePlugin
implements Authenticator {
    private final Map<String, PwdCredentialAccount> accounts = new HashMap<String, PwdCredentialAccount>();

    @InjectConfiguration
    public void init(Map<String, Object> confArgs) throws FileNotFoundException, ConfigurationException {
        this.init(confArgs, "users");
    }

    public Consumer<? super Map<String, Object>> consumeConfiguration() {
        return u -> {
            try {
                String userid = (String)ConfigurablePlugin.argValue((Map)u, (String)"userid");
                String _password = (String)ConfigurablePlugin.argValue((Map)u, (String)"password");
                char[] password = _password.toCharArray();
                List _roles = (List)ConfigurablePlugin.argValue((Map)u, (String)"roles");
                if (_roles.stream().anyMatch(i -> !(i instanceof String))) {
                    throw new IllegalArgumentException("wrong configuration file format. a roles entry is wrong. they all must be strings");
                }
                LinkedHashSet roles = Sets.newLinkedHashSet((Iterable)_roles);
                PwdCredentialAccount a = new PwdCredentialAccount(userid, password, (Set)roles);
                this.accounts.put(userid, a);
            }
            catch (ConfigurationException pce) {
                LambdaUtils.throwsSneakyExcpetion((Throwable)pce);
            }
        };
    }

    public Account verify(Account account) {
        return account;
    }

    public Account verify(String id, Credential credential) {
        Account account = (Account)this.accounts.get(id);
        return account != null && this.verifyCredential(account, credential) ? account : null;
    }

    public Account verify(Credential credential) {
        return null;
    }

    private boolean verifyCredential(Account account, Credential credential) {
        if (account instanceof PwdCredentialAccount) {
            if (credential instanceof PasswordCredential) {
                return this.verifyPasswordCredential(account, credential);
            }
            if (credential instanceof DigestCredential) {
                return this.verifyDigestCredential(account, credential);
            }
        }
        return false;
    }

    private boolean verifyPasswordCredential(Account account, Credential credential) {
        char[] password = ((PasswordCredential)credential).getPassword();
        char[] expectedPassword = this.accounts.get(account.getPrincipal().getName()).getCredentials().getPassword();
        return Arrays.equals(password, expectedPassword);
    }

    private boolean verifyDigestCredential(Account account, Credential credential) {
        try {
            DigestCredential dc = (DigestCredential)credential;
            MessageDigest digest = dc.getAlgorithm().getMessageDigest();
            String expectedPassword = new String(this.accounts.get(account.getPrincipal().getName()).getCredentials().getPassword());
            digest.update(account.getPrincipal().getName().getBytes(StandardCharsets.UTF_8));
            digest.update((byte)58);
            digest.update(dc.getRealm().getBytes(StandardCharsets.UTF_8));
            digest.update((byte)58);
            digest.update(expectedPassword.getBytes(StandardCharsets.UTF_8));
            byte[] ha1 = HexConverter.convertToHexBytes((byte[])digest.digest());
            return dc.verifyHA1(ha1);
        }
        catch (NoSuchAlgorithmException ne) {
            return false;
        }
    }
}

