/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.services;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.util.Map;
import org.restheart.ConfigurationException;
import org.restheart.exchange.JsonRequest;
import org.restheart.exchange.JsonResponse;
import org.restheart.plugins.ConfigurablePlugin;
import org.restheart.plugins.InjectConfiguration;
import org.restheart.plugins.InjectPluginsRegistry;
import org.restheart.plugins.JsonService;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.BaseAccount;
import org.restheart.plugins.security.TokenManager;

@RegisterPlugin(name="rndTokenService", description="allows to get and invalidate the user auth token generated by RndTokenManager", enabledByDefault=true, defaultURI="/tokens")
public class RndTokenService
implements JsonService {
    private static final Escaper ESCAPER = UrlEscapers.urlPathSegmentEscaper();
    private Map<String, Object> confArgs = null;
    private PluginsRegistry pluginRegistry;

    @InjectPluginsRegistry
    public void setPluginRegistry(PluginsRegistry pluginRegistry) {
        this.pluginRegistry = pluginRegistry;
    }

    @InjectConfiguration
    public void init(Map<String, Object> confArgs) throws ConfigurationException {
        this.confArgs = confArgs;
    }

    public void handle(JsonRequest request, JsonResponse response) throws Exception {
        HttpServerExchange exchange = request.getExchange();
        if (exchange.getRequestPath().startsWith(this.getUri()) && exchange.getRequestPath().length() >= this.getUri().length() + 2 && Methods.OPTIONS.equals(exchange.getRequestMethod())) {
            exchange.getResponseHeaders().put(HttpString.tryFromString((String)"Access-Control-Allow-Methods"), "GET, DELETE").put(HttpString.tryFromString((String)"Access-Control-Allow-Headers"), "Accept, Accept-Encoding, Authorization, Content-Length, Content-Type, Host, Origin, X-Requested-With, User-Agent, No-Auth-Challenge");
            response.setStatusCode(200);
            return;
        }
        if (exchange.getSecurityContext() == null || exchange.getSecurityContext().getAuthenticatedAccount() == null || exchange.getSecurityContext().getAuthenticatedAccount().getPrincipal() == null) {
            response.setStatusCode(401);
            return;
        }
        if (!(this.getUri() + "/" + exchange.getSecurityContext().getAuthenticatedAccount().getPrincipal().getName()).equals(exchange.getRequestURI()) && !ESCAPER.escape(this.getUri() + "/" + exchange.getSecurityContext().getAuthenticatedAccount().getPrincipal().getName()).equals(exchange.getRequestURI())) {
            response.setStatusCode(403);
            return;
        }
        if (Methods.GET.equals(exchange.getRequestMethod())) {
            JsonObject resp = new JsonObject();
            resp.add("auth_token", (JsonElement)new JsonPrimitive(exchange.getResponseHeaders().get(TokenManager.AUTH_TOKEN_HEADER).getFirst()));
            resp.add("auth_token_valid_until", (JsonElement)new JsonPrimitive(exchange.getResponseHeaders().get(TokenManager.AUTH_TOKEN_VALID_HEADER).getFirst()));
            response.setStatusCode(200);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
            exchange.getResponseSender().send(resp.toString());
        } else if (Methods.DELETE.equals(exchange.getRequestMethod())) {
            BaseAccount account = new BaseAccount(exchange.getSecurityContext().getAuthenticatedAccount().getPrincipal().getName(), null);
            this.invalidate((Account)account);
            this.removeAuthTokens(exchange);
            response.setStatusCode(204);
        } else {
            response.setStatusCode(405);
        }
    }

    private void invalidate(Account account) {
        PluginRecord tokenManager = this.pluginRegistry.getTokenManager();
        if (tokenManager == null) {
            throw new IllegalStateException("Error, cannot invalidate, token manager not active");
        }
        ((TokenManager)tokenManager.getInstance()).invalidate(account);
    }

    private void removeAuthTokens(HttpServerExchange exchange) {
        exchange.getResponseHeaders().remove(TokenManager.AUTH_TOKEN_HEADER);
        exchange.getResponseHeaders().remove(TokenManager.AUTH_TOKEN_VALID_HEADER);
        exchange.getResponseHeaders().remove(TokenManager.AUTH_TOKEN_LOCATION_HEADER);
    }

    private String getUri() {
        if (this.confArgs == null) {
            return "/tokens";
        }
        try {
            return (String)ConfigurablePlugin.argValue(this.confArgs, (String)"uri");
        }
        catch (ConfigurationException ex) {
            return "/tokens";
        }
    }
}

