/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.authorizers;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import io.undertow.predicate.Predicate;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.restheart.ConfigurationException;
import org.restheart.cache.Cache;
import org.restheart.cache.CacheFactory;
import org.restheart.cache.LoadingCache;
import org.restheart.exchange.Request;
import org.restheart.plugins.ConfigurablePlugin;
import org.restheart.plugins.InjectConfiguration;
import org.restheart.plugins.InjectMongoClient;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.Authorizer;
import org.restheart.security.plugins.authorizers.FilterPredicate;
import org.restheart.security.utils.MongoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="mongoAclAuthorizer", description="authorizes requests against acl stored in mongodb")
public class MongoAclAuthorizer
implements Authorizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoAclAuthorizer.class);
    public static final String X_FORWARDED_ACCOUNT_ID = "rhAuthenticator";
    public static final String X_FORWARDED_ROLE = "RESTHeart";
    public static final AttachmentKey<FilterPredicate> MATCHING_ACL_PREDICATE = AttachmentKey.create(FilterPredicate.class);
    public static final String ACL_COLLECTION_NAME = "acl";
    public static String MREST_SUPERUSER_ROLE = "__MREST_SUPERUSER";
    public static final String $UNAUTHENTICATED = "$unauthenticated";
    String aclDb;
    String aclCollection;
    private String rootRole = null;
    private boolean cacheEnabled = false;
    private Integer cacheSize = 1000;
    private Integer cacheTTL = 60000;
    private Cache.EXPIRE_POLICY cacheExpirePolicy = Cache.EXPIRE_POLICY.AFTER_WRITE;
    private LoadingCache<String, LinkedHashSet<FilterPredicate>> acl = null;
    private MongoClient mclient;
    private static final BsonDocument PROJECTION = BsonDocument.parse((String)"{\"_id\":1,\"roles\":1,\"predicate\":1,\"writeFilter\":1,\"readFilter\":1,\"priority\":1}");
    private static final BsonDocument SORT = BsonDocument.parse((String)"{\"priority\":-1,\"_id\":-1}");

    @InjectConfiguration
    public void setConf(Map<String, Object> args) {
        this.aclDb = (String)ConfigurablePlugin.argValue(args, (String)"acl-db");
        this.aclCollection = (String)ConfigurablePlugin.argValue(args, (String)"acl-collection");
        this.rootRole = (String)ConfigurablePlugin.argValue(args, (String)"root-role");
        if (args != null && args.containsKey("cache-enabled")) {
            this.cacheEnabled = (Boolean)ConfigurablePlugin.argValue(args, (String)"cache-enabled");
            if (this.cacheEnabled) {
                this.cacheSize = (Integer)ConfigurablePlugin.argValue(args, (String)"cache-size");
                this.cacheTTL = (Integer)ConfigurablePlugin.argValue(args, (String)"cache-ttl");
                String _cacheExpirePolicy = (String)ConfigurablePlugin.argValue(args, (String)"cache-expire-policy");
                if (_cacheExpirePolicy != null) {
                    try {
                        this.cacheExpirePolicy = Cache.EXPIRE_POLICY.valueOf((String)_cacheExpirePolicy);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ConfigurationException("wrong configuration file format. cache-expire-policy valid values are " + Arrays.toString(Cache.EXPIRE_POLICY.values()));
                    }
                }
                this.acl = CacheFactory.createLocalLoadingCache((long)this.cacheSize.intValue(), (Cache.EXPIRE_POLICY)this.cacheExpirePolicy, (long)this.cacheTTL.intValue(), role -> this.findRolePredicates((String)role));
            }
        }
    }

    @InjectMongoClient
    public void setMongoClient(MongoClient mclient) {
        this.mclient = mclient;
        if (!this.checkAclCollection()) {
            LOGGER.error("ACL collection does not exist and could not be created");
        }
    }

    public boolean isAllowed(Request request) {
        if (request.isOptions()) {
            return true;
        }
        HttpServerExchange exchange = request.getExchange();
        if (this.rootRole != null && exchange.getSecurityContext() != null && exchange.getSecurityContext().getAuthenticatedAccount() != null && exchange.getSecurityContext().getAuthenticatedAccount().getRoles().contains(this.rootRole)) {
            LOGGER.debug("allow request for root user {}", (Object)exchange.getSecurityContext().getAuthenticatedAccount().getPrincipal().getName());
            return true;
        }
        if (exchange.getAttachment(Predicate.PREDICATE_CONTEXT) == null) {
            exchange.putAttachment(Predicate.PREDICATE_CONTEXT, new TreeMap());
        }
        exchange.setRelativePath(exchange.getRequestPath());
        ArrayList predicates = new ArrayList();
        if (LOGGER.isDebugEnabled()) {
            this.roles(exchange).forEachOrdered(role -> {
                ArrayList matched = Lists.newArrayListWithCapacity((int)1);
                this.predicatesForRole((String)role).stream().anyMatch(predicate -> {
                    String marker;
                    boolean resolved = predicate.resolve(exchange);
                    if (resolved && matched.isEmpty()) {
                        matched.add(predicate);
                        marker = "<--";
                    } else {
                        marker = "";
                    }
                    LOGGER.debug("role {}, predicate {}, resolve {} {}", new Object[]{role, predicate.getId(), resolved, marker});
                    return false;
                });
            });
        }
        this.roles(exchange).forEachOrdered(role -> this.predicatesForRole((String)role).stream().anyMatch(r -> {
            if (r.resolve(exchange)) {
                predicates.add(r);
                return true;
            }
            return false;
        }));
        if (predicates.isEmpty()) {
            return false;
        }
        exchange.putAttachment(MATCHING_ACL_PREDICATE, (Object)((FilterPredicate)predicates.get(0)));
        return true;
    }

    public boolean isAuthenticationRequired(Request request) {
        if (request.isOptions()) {
            return false;
        }
        HttpServerExchange exchange = request.getExchange();
        LinkedHashSet<FilterPredicate> ps = this.getRoleFilterPredicates($UNAUTHENTICATED);
        if (ps != null) {
            if (exchange.getAttachment(Predicate.PREDICATE_CONTEXT) == null) {
                exchange.putAttachment(Predicate.PREDICATE_CONTEXT, new TreeMap());
            }
            exchange.setRelativePath(request.getPath());
            return !ps.stream().anyMatch(r -> r.resolve(exchange));
        }
        return true;
    }

    private Stream<String> roles(HttpServerExchange exchange) {
        return this.account(exchange).getRoles().stream();
    }

    private LinkedHashSet<FilterPredicate> predicatesForRole(String role) {
        LinkedHashSet<FilterPredicate> predicates = this.getRoleFilterPredicates(role);
        if (predicates == null) {
            return Sets.newLinkedHashSet();
        }
        return predicates;
    }

    private Account account(HttpServerExchange exchange) {
        Account account = exchange.getSecurityContext().getAuthenticatedAccount();
        return this.isAuthenticated(account) ? account : new NotAuthenticatedAccount();
    }

    private boolean isAuthenticated(Account authenticatedAccount) {
        return authenticatedAccount != null;
    }

    public LinkedHashSet<FilterPredicate> getRoleFilterPredicates(String role) {
        if (this.cacheEnabled) {
            Optional _roleFilterPredicates = this.acl.getLoading((Object)role);
            if (_roleFilterPredicates != null && _roleFilterPredicates.isPresent()) {
                return (LinkedHashSet)_roleFilterPredicates.get();
            }
            return null;
        }
        return this.findRolePredicates(role);
    }

    private LinkedHashSet<FilterPredicate> findRolePredicates(String role) {
        if (this.mclient == null) {
            LOGGER.error("Cannot find acl: mongo service is not enabled.");
            return null;
        }
        FindIterable predicates = this.mclient.getDatabase(this.aclDb).getCollection(this.aclCollection, BsonDocument.class).find(Filters.eq((String)"roles", (Object)role)).projection((Bson)PROJECTION).sort((Bson)SORT);
        if (predicates == null) {
            return new LinkedHashSet<FilterPredicate>();
        }
        LinkedHashSet ret = Sets.newLinkedHashSet();
        StreamSupport.stream(predicates.spliterator(), true).filter(predicateElem -> predicateElem.isDocument()).map(predicateElem -> predicateElem.asDocument()).filter(predicateDocument -> {
            try {
                new FilterPredicate((BsonDocument)predicateDocument);
                return true;
            }
            catch (IllegalArgumentException iae) {
                LOGGER.warn("invalid predicate _id={}", (Object)predicateDocument.get((Object)"_id"));
                return false;
            }
        }).map(predicateDocument -> new FilterPredicate((BsonDocument)predicateDocument)).forEachOrdered(p -> ret.add(p));
        return ret;
    }

    public boolean checkAclCollection() {
        if (this.mclient == null) {
            LOGGER.error("Cannot check acl collection: mongo service is not enabled.");
            return false;
        }
        try {
            MongoUtils mu = new MongoUtils(this.mclient);
            if (!mu.doesDbExist(this.aclDb)) {
                mu.createDb(this.aclDb);
            }
            if (!mu.doesCollectionExist(this.aclDb, this.aclCollection)) {
                mu.createCollection(this.aclDb, this.aclCollection);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error creating acl collection", t);
            return false;
        }
        return true;
    }

    private static class NotAuthenticatedAccount
    implements Account {
        private NotAuthenticatedAccount() {
        }

        public Principal getPrincipal() {
            return null;
        }

        public Set<String> getRoles() {
            return Sets.newHashSet((Object[])new String[]{MongoAclAuthorizer.$UNAUTHENTICATED});
        }
    }
}

