/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.authenticators;

import com.google.gson.JsonElement;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import org.restheart.ConfigurationException;
import org.restheart.exchange.MongoRequest;
import org.restheart.exchange.MongoResponse;
import org.restheart.plugins.InjectPluginsRegistry;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.MongoInterceptor;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.security.plugins.authenticators.MongoRealmAuthenticator;
import org.restheart.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="userPwdRemover", description="filters out the password from the response", interceptPoint=InterceptPoint.RESPONSE, requiresContent=true)
public class UserPwdRemover
implements MongoInterceptor {
    static final Logger LOGGER = LoggerFactory.getLogger(UserPwdRemover.class);
    private String usersDb;
    private String usersCollection;
    private String propNamePassword;
    private boolean enabled = false;

    @InjectPluginsRegistry
    public void init(PluginsRegistry registry) {
        PluginRecord _mra;
        try {
            _mra = registry.getAuthenticator("mongoRealmAuthenticator");
        }
        catch (ConfigurationException ce) {
            this.enabled = false;
            return;
        }
        if (_mra == null || !_mra.isEnabled()) {
            this.enabled = false;
        } else {
            MongoRealmAuthenticator rhAuth = (MongoRealmAuthenticator)_mra.getInstance();
            this.usersDb = rhAuth.getUsersDb();
            this.usersCollection = rhAuth.getUsersCollection();
            this.propNamePassword = rhAuth.getPropPassword();
            if (this.usersDb == null || this.usersCollection == null || this.propNamePassword == null) {
                LOGGER.error("Wrong configuration of mongoRealmAuthenticator! Password stored in users collection are not filtered out from the response");
                this.enabled = false;
            } else {
                this.enabled = true;
            }
        }
    }

    public void handle(MongoRequest request, MongoResponse response) throws Exception {
        DocumentContext dc = JsonPath.parse((String)response.readContent());
        JsonElement content = (JsonElement)dc.json();
        if (content == null || content.isJsonNull()) {
            return;
        }
        if (content.isJsonArray()) {
            dc.delete("$.[*].".concat(this.propNamePassword), new Predicate[0]);
        } else if (content.isJsonObject() && content.getAsJsonObject().keySet().contains("_embedded")) {
            if (content.getAsJsonObject().get("_embedded").isJsonArray()) {
                dc.delete("$._embedded.*.".concat(this.propNamePassword), new Predicate[0]);
            } else if (content.getAsJsonObject().get("_embedded").isJsonObject() && content.getAsJsonObject().get("_embedded").getAsJsonObject().keySet().contains("rh:doc") && content.getAsJsonObject().get("_embedded").getAsJsonObject().get("rh:doc").isJsonArray()) {
                dc.delete("$._embedded.['rh:doc'].*.".concat(this.propNamePassword), new Predicate[0]);
            }
        } else if (content.isJsonObject()) {
            dc.delete("$.".concat(this.propNamePassword), new Predicate[0]);
        }
        response.setContent((Object)JsonUtils.parse((String)content.toString()));
    }

    public boolean resolve(MongoRequest request, MongoResponse response) {
        return this.enabled && request.isGet() && this.usersDb.equalsIgnoreCase(request.getDBName()) && this.usersCollection.equalsIgnoreCase(request.getCollectionName()) && response.getContent() != null;
    }
}

