/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.authorizers;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateParser;
import io.undertow.server.HttpServerExchange;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.restheart.security.plugins.authorizers.MongoAclAuthorizer;
import org.restheart.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterPredicate {
    private final BsonValue _id;
    private final Set<String> roles;
    private final Predicate predicate;
    private final BsonDocument readFilter;
    private final BsonDocument writeFilter;
    private final int priority;
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterPredicate.class);

    FilterPredicate(BsonValue _id, Set<String> roles, Predicate predicate, BsonDocument readFilter, BsonDocument writeFilter, int priority) {
        this._id = _id;
        this.roles = roles;
        this.predicate = predicate;
        this.readFilter = readFilter;
        this.writeFilter = writeFilter;
        this.priority = priority;
    }

    FilterPredicate(BsonDocument doc) {
        this._id = doc.get((Object)"_id");
        BsonValue _roles = doc.get((Object)"roles");
        if (_roles == null || !_roles.isArray() || _roles.asArray().isEmpty()) {
            throw new IllegalArgumentException("roles must be an not empty array of strings");
        }
        if (StreamSupport.stream(_roles.asArray().spliterator(), true).anyMatch(el -> el == null || !el.isString())) {
            throw new IllegalArgumentException("roles must be an not empty array of strings");
        }
        this.roles = StreamSupport.stream(_roles.asArray().spliterator(), true).map(role -> role.asString()).map(role -> role.getValue()).collect(Collectors.toSet());
        BsonValue _predicate = doc.get((Object)"predicate");
        if (_predicate == null || !_predicate.isString()) {
            throw new IllegalArgumentException("_predicate must be a string");
        }
        try {
            this.predicate = PredicateParser.parse((String)_predicate.asString().getValue(), (ClassLoader)this.getClass().getClassLoader());
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("wrong predicate " + _predicate, t);
        }
        BsonValue _readFilter = doc.get((Object)"readFilter");
        if (_readFilter != null && !_readFilter.isNull() && !_readFilter.isDocument()) {
            throw new IllegalArgumentException("readFilter must be a JSON object or null");
        }
        this.readFilter = _readFilter == null ? null : (_readFilter.isNull() ? null : JsonUtils.escapeKeys((BsonValue)_readFilter.asDocument(), (boolean)true).asDocument());
        BsonValue _writeFilter = doc.get((Object)"writeFilter");
        if (_writeFilter != null && !_writeFilter.isNull() && !_writeFilter.isDocument()) {
            throw new IllegalArgumentException("writeFilter must be a JSON object or null");
        }
        this.writeFilter = _writeFilter == null ? null : (_writeFilter.isNull() ? null : JsonUtils.escapeKeys((BsonValue)_writeFilter.asDocument(), (boolean)true).asDocument());
        BsonValue _priority = doc.get((Object)"priority");
        if (_priority == null || _priority.isNull() || !_priority.isNumber()) {
            this.priority = Integer.MAX_VALUE;
            LOGGER.warn("predicate {} doesn't have priority; setting it to 0", (Object)this._id);
        } else {
            this.priority = _priority.asNumber().intValue();
        }
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public BsonDocument getReadFilter() {
        return this.readFilter == null || this.readFilter.isNull() ? null : JsonUtils.unescapeKeys((BsonValue)this.readFilter).asDocument();
    }

    public BsonDocument getWriteFilter() {
        return this.writeFilter == null || this.writeFilter.isNull() ? this.writeFilter : JsonUtils.unescapeKeys((BsonValue)this.writeFilter).asDocument();
    }

    public int getPriority() {
        return this.priority;
    }

    public BsonValue getId() {
        return this._id;
    }

    public static FilterPredicate from(HttpServerExchange exchange) {
        return (FilterPredicate)exchange.getAttachment(MongoAclAuthorizer.MATCHING_ACL_PREDICATE);
    }

    public boolean resolve(HttpServerExchange exchange) {
        if (this.predicate == null) {
            return false;
        }
        return this.predicate.resolve(exchange);
    }

    public static JsonObject interpolateFilterVars(HttpServerExchange exchange, BsonDocument filter) {
        if (Objects.isNull(filter) || filter.isNull()) {
            return null;
        }
        String ret = filter.toString();
        String username = ExchangeAttributes.remoteUser().readAttribute(exchange);
        if (username != null) {
            ret = ret.replace("%USER", username);
        }
        if (Objects.nonNull(exchange.getSecurityContext()) && Objects.nonNull(exchange.getSecurityContext().getAuthenticatedAccount()) && Objects.nonNull(exchange.getSecurityContext().getAuthenticatedAccount().getRoles())) {
            String roles = exchange.getSecurityContext().getAuthenticatedAccount().getRoles().toString();
            ret = ret.replace("%ROLES", roles);
        } else {
            ret = ret.replace("%ROLES", "[]");
        }
        long now = Instant.now().getEpochSecond() * 1000L;
        ret = ret.replace("%NOW", "{'$date':" + now + "}");
        return JsonParser.parseString((String)ret).getAsJsonObject();
    }
}

