/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.authorizers;

import com.google.gson.JsonObject;
import io.undertow.server.HttpServerExchange;
import java.util.ArrayDeque;
import java.util.Optional;
import org.bson.BsonDocument;
import org.restheart.exchange.MongoRequest;
import org.restheart.exchange.MongoResponse;
import org.restheart.plugins.InjectPluginsRegistry;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.MongoInterceptor;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.security.plugins.authorizers.FilterPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="filterPredicateInjector", description="inject the filter set by ACL into the request", interceptPoint=InterceptPoint.REQUEST_AFTER_AUTH)
public class FilterPredicateInjector
implements MongoInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterPredicateInjector.class);
    private boolean enabled = false;

    @InjectPluginsRegistry
    public void init(PluginsRegistry registry) {
        Optional<PluginRecord> __maa = registry.getAuthorizers().stream().filter(a -> "mongoAclAuthorizer".equals(a.getName())).findFirst();
        this.enabled = __maa == null || !__maa.isPresent() ? false : __maa.get().isEnabled();
    }

    public void handle(MongoRequest request, MongoResponse response) throws Exception {
        HttpServerExchange exchange = request.getExchange();
        FilterPredicate predicate = FilterPredicate.from(exchange);
        if (request.isGet() && predicate.getReadFilter() != null) {
            LOGGER.debug("read filter: {}", (Object)predicate.getReadFilter());
            this.addFilter(request, predicate.getReadFilter());
        } else if ((request.isPatch() || request.isPut() || request.isPost() || request.isDelete()) && predicate.getWriteFilter() != null) {
            LOGGER.debug("write filter to add: {}", (Object)predicate.getWriteFilter());
            this.addFilter(request, predicate.getWriteFilter());
        } else {
            LOGGER.trace("predicate specifies no filter");
        }
    }

    public boolean resolve(MongoRequest request, MongoResponse response) {
        return this.enabled && request.isHandledBy("mongo") && FilterPredicate.from(request.getExchange()) != null;
    }

    private void addFilter(MongoRequest request, BsonDocument filter) {
        if (filter == null) {
            return;
        }
        JsonObject resolvedFilter = FilterPredicate.interpolateFilterVars(request.getExchange(), filter);
        if (request.getFilter() == null) {
            request.setFilter(new ArrayDeque());
        }
        request.getFilter().add(resolvedFilter.toString());
    }
}

