/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.services;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.Map;
import java.util.Set;
import org.restheart.ConfigurationException;
import org.restheart.exchange.JsonRequest;
import org.restheart.exchange.JsonResponse;
import org.restheart.plugins.ConfigurablePlugin;
import org.restheart.plugins.InjectConfiguration;
import org.restheart.plugins.JsonService;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.TokenManager;
import org.restheart.utils.URLUtils;

@RegisterPlugin(name="roles", description="returns the roles of the authenticated client", enabledByDefault=true, defaultURI="/roles")
public class GetRoleService
implements JsonService {
    Map<String, Object> confArgs = null;

    @InjectConfiguration
    public void init(Map<String, Object> confArgs) {
        this.confArgs = confArgs;
    }

    public void handle(JsonRequest request, JsonResponse response) throws Exception {
        HttpServerExchange exchange = request.getExchange();
        if (request.isOptions()) {
            response.getHeaders().put(HttpString.tryFromString((String)"Access-Control-Allow-Methods"), "GET");
            response.getHeaders().put(HttpString.tryFromString((String)"Access-Control-Allow-Headers"), "Accept, Accept-Encoding, Authorization, Content-Length, Content-Type, Host, Origin, X-Requested-With, User-Agent, No-Auth-Challenge, " + TokenManager.AUTH_TOKEN_HEADER + ", " + TokenManager.AUTH_TOKEN_VALID_HEADER + ", " + TokenManager.AUTH_TOKEN_LOCATION_HEADER);
            exchange.setStatusCode(200);
            exchange.endExchange();
        } else if (request.isGet()) {
            if (exchange.getSecurityContext() == null || exchange.getSecurityContext().getAuthenticatedAccount() == null || exchange.getSecurityContext().getAuthenticatedAccount().getPrincipal() == null || !exchange.getRequestURI().equals(URLUtils.removeTrailingSlashes((String)this.getUri()) + "/" + exchange.getSecurityContext().getAuthenticatedAccount().getPrincipal().getName())) {
                exchange.setStatusCode(403);
                response.getHeaders().remove(TokenManager.AUTH_TOKEN_HEADER);
                response.getHeaders().remove(TokenManager.AUTH_TOKEN_VALID_HEADER);
                response.getHeaders().remove(TokenManager.AUTH_TOKEN_LOCATION_HEADER);
                exchange.endExchange();
                return;
            }
            JsonObject root = new JsonObject();
            Set _roles = exchange.getSecurityContext().getAuthenticatedAccount().getRoles();
            JsonArray roles = new JsonArray();
            _roles.forEach(role -> roles.add((JsonElement)new JsonPrimitive(role)));
            root.add("authenticated", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            root.add("roles", (JsonElement)roles);
            exchange.getResponseSender().send(root.toString());
            exchange.endExchange();
        } else {
            exchange.setStatusCode(405);
            exchange.endExchange();
        }
    }

    private String getUri() {
        if (this.confArgs == null) {
            return "/roles";
        }
        try {
            return (String)ConfigurablePlugin.argValue(this.confArgs, (String)"uri");
        }
        catch (ConfigurationException ex) {
            return "/roles";
        }
    }
}

