/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.plugins.interceptors;

import io.undertow.util.HeaderValues;
import org.restheart.exchange.MongoRequest;
import org.restheart.exchange.MongoResponse;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.MongoInterceptor;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.TokenManager;

@RegisterPlugin(name="tokenCORSResponseInterceptor", description="helper interceptor to add token headers to Access-Control-Expose-Headers to handle CORS request", interceptPoint=InterceptPoint.RESPONSE, enabledByDefault=true)
public class TokenCORSResponseInterceptor
implements MongoInterceptor {
    private String[] headers;

    public TokenCORSResponseInterceptor() {
        this.headers = new String[0];
    }

    public TokenCORSResponseInterceptor(String ... headers) {
        this.headers = headers;
    }

    public void handle(MongoRequest request, MongoResponse response) throws Exception {
        HeaderValues hs = response.getHeaders().get(TokenManager.ACCESS_CONTROL_EXPOSE_HEADERS);
        if (hs == null || hs.isEmpty()) {
            response.getHeaders().put(TokenManager.ACCESS_CONTROL_EXPOSE_HEADERS, this.headers());
        } else {
            String v0 = hs.getFirst();
            for (String h : this.headers) {
                if (v0.contains(h)) continue;
                v0 = v0.concat(", ").concat(h);
            }
            response.getHeaders().put(TokenManager.ACCESS_CONTROL_EXPOSE_HEADERS, v0);
        }
    }

    public boolean resolve(MongoRequest request, MongoResponse response) {
        return true;
    }

    private String headers() {
        String ret = "";
        boolean first = true;
        for (String h : this.headers) {
            if (first) {
                ret = ret.concat(h);
                first = false;
                continue;
            }
            ret = ret.concat(", ").concat(h);
        }
        return ret;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
    }
}

