/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.utils;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;

public class MongoUtils {
    MongoClient client;

    public MongoUtils(MongoClient client) {
        this.client = client;
    }

    public boolean doesDbExist(String dbName) {
        return this.client.getDatabase(dbName).listCollectionNames().first() != null;
    }

    public boolean doesCollectionExist(String dbName, String collName) {
        for (String dbCollection : this.client.getDatabase(dbName).listCollectionNames()) {
            if (!collName.equals(dbCollection)) continue;
            return true;
        }
        return false;
    }

    public void createDb(String dbName) {
        this.client.getDatabase(dbName).createCollection("_properties");
        MongoCollection pc = this.client.getDatabase(dbName).getCollection("_properties", BsonDocument.class);
        BsonDocument doc = new BsonDocument();
        doc.put("_id", (BsonValue)new BsonString("_properties"));
        doc.put("_etag", (BsonValue)new BsonObjectId());
        pc.insertOne((Object)doc);
    }

    public void createCollection(String dbName, String collName) {
        MongoCollection pc = this.client.getDatabase(dbName).getCollection("_properties", BsonDocument.class);
        BsonDocument doc = new BsonDocument();
        doc.put("_id", (BsonValue)new BsonString("_properties.".concat(collName)));
        doc.put("_etag", (BsonValue)new BsonObjectId());
        pc.insertOne((Object)doc);
        this.client.getDatabase(dbName).createCollection(collName);
    }
}

