/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.predicates;

import com.google.common.collect.Sets;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class QParamsContainPredicate
implements Predicate {
    private final Set<String> qparams;

    public QParamsContainPredicate(String[] qparams) {
        if (qparams == null || qparams.length < 1) {
            throw new IllegalArgumentException("qparams-contains predicate must specify a list of query parameters");
        }
        this.qparams = Sets.newHashSet((Object[])qparams);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean resolve(HttpServerExchange exchange) {
        Map qparamsInExchange = exchange.getQueryParameters();
        if (qparamsInExchange == null) {
            if (this.qparams.size() == 0) return true;
        }
        if (qparamsInExchange == null) return false;
        if (!this.qparams.stream().allMatch(qparamsInExchange.keySet()::contains)) return false;
        return true;
    }

    public static class Builder
    implements PredicateBuilder {
        public String name() {
            return "qparams-contain";
        }

        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("qparams", String[].class);
        }

        public Set<String> requiredParameters() {
            return Collections.singleton("qparams");
        }

        public String defaultParameter() {
            return "qparams";
        }

        public Predicate build(Map<String, Object> config) {
            return new QParamsContainPredicate((String[])config.get("qparams"));
        }
    }
}

