/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.mechanisms;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.HttpServerExchange;
import java.lang.reflect.Field;
import java.util.Map;
import org.restheart.ConfigurationException;
import org.restheart.plugins.ConfigurablePlugin;
import org.restheart.plugins.InjectConfiguration;
import org.restheart.plugins.InjectPluginsRegistry;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.AuthMechanism;

@RegisterPlugin(name="basicAuthMechanism", description="handles the basic authentication scheme", enabledByDefault=false)
public class BasicAuthMechanism
extends BasicAuthenticationMechanism
implements AuthMechanism {
    public static final String SILENT_HEADER_KEY = "No-Auth-Challenge";
    public static final String SILENT_QUERY_PARAM_KEY = "noauthchallenge";

    public BasicAuthMechanism() throws ConfigurationException {
        super("RESTHeart Realm", "basicAuthMechanism", false);
    }

    @InjectConfiguration
    @InjectPluginsRegistry
    public void init(Map<String, Object> args, PluginsRegistry pluginsRegistry) throws ConfigurationException {
        this.setIdentityManager((IdentityManager)pluginsRegistry.getAuthenticator((String)ConfigurablePlugin.argValue(args, (String)"authenticator")).getInstance());
    }

    private void setIdentityManager(IdentityManager idm) {
        try {
            Class<?> clazz = Class.forName("io.undertow.security.impl.BasicAuthenticationMechanism");
            Field idmF = clazz.getDeclaredField("identityManager");
            idmF.setAccessible(true);
            idmF.set((Object)this, idm);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException("Error setting identity manager", ex);
        }
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        if (exchange.getRequestHeaders().contains(SILENT_HEADER_KEY) || exchange.getQueryParameters().containsKey(SILENT_QUERY_PARAM_KEY)) {
            return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(401));
        }
        return super.sendChallenge(exchange, securityContext);
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        return super.authenticate(exchange, securityContext);
    }
}

