/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.tokens;

import com.google.common.collect.Sets;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.HttpServerExchange;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.restheart.ConfigurationException;
import org.restheart.cache.Cache;
import org.restheart.cache.CacheFactory;
import org.restheart.exchange.JsonProxyRequest;
import org.restheart.plugins.ConfigurablePlugin;
import org.restheart.plugins.InjectConfiguration;
import org.restheart.plugins.InjectPluginsRegistry;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.TokenManager;
import org.restheart.security.FileRealmAccount;
import org.restheart.security.MongoRealmAccount;
import org.restheart.security.PwdCredentialAccount;
import org.restheart.security.interceptors.TokenCORSResponseInterceptor;
import org.restheart.utils.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="rndTokenManager", description="generates random auth tokens", enabledByDefault=false)
public class RndTokenManager
implements TokenManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RndTokenManager.class);
    private static final SecureRandom RND_GENERATOR = new SecureRandom();
    private static Cache<String, PwdCredentialAccount> CACHE = null;
    private int ttl = -1;
    private String srvURI = null;

    @InjectConfiguration
    @InjectPluginsRegistry
    public void init(Map<String, Object> confArgs, PluginsRegistry pluginsRegistry) throws ConfigurationException {
        this.ttl = (Integer)ConfigurablePlugin.argValue(confArgs, (String)"ttl");
        this.srvURI = (String)ConfigurablePlugin.argValue(confArgs, (String)"srv-uri");
        CACHE = CacheFactory.createLocalCache((long)Long.MAX_VALUE, (Cache.EXPIRE_POLICY)Cache.EXPIRE_POLICY.AFTER_READ, (long)(this.ttl * 60 * 1000));
        String[] headers = new String[]{AUTH_TOKEN_HEADER.toString(), AUTH_TOKEN_VALID_HEADER.toString(), AUTH_TOKEN_LOCATION_HEADER.toString()};
        Optional<PluginRecord> ti = pluginsRegistry.getInterceptors().stream().filter(i -> "tokenCORSResponseInterceptor".equals(i.getName())).findFirst();
        if (ti.isPresent()) {
            ((TokenCORSResponseInterceptor)ti.get().getInstance()).setHeaders(headers);
        } else {
            LOGGER.warn("Cound not find tokenCORSResponseInterceptor. Auth token headers are not added to CORS");
        }
    }

    public Account verify(Account account) {
        return account;
    }

    public Account verify(String id, Credential credential) {
        Optional _account = CACHE.get((Object)id);
        return _account != null && _account.isPresent() && this.verifyToken((PwdCredentialAccount)_account.get(), credential) ? (Account)_account.get() : null;
    }

    public Account verify(Credential credential) {
        return null;
    }

    private boolean verifyToken(PwdCredentialAccount account, Credential credential) {
        if (credential instanceof PasswordCredential) {
            char[] token = ((PasswordCredential)credential).getPassword();
            char[] expectedToken = account.getCredentials().getPassword();
            return Arrays.equals(token, expectedToken);
        }
        return false;
    }

    public Cache<String, PwdCredentialAccount> getCACHE() {
        return CACHE;
    }

    public PasswordCredential get(Account account) {
        Optional cachedAccount = CACHE.get((Object)account.getPrincipal().getName());
        if (cachedAccount != null && cachedAccount.isPresent()) {
            return ((PwdCredentialAccount)cachedAccount.get()).getCredentials();
        }
        PwdCredentialAccount newCachedTokenAccount = this.cloneWithToken(account, RndTokenManager.nextToken());
        CACHE.put((Object)account.getPrincipal().getName(), (Object)newCachedTokenAccount);
        return newCachedTokenAccount.getCredentials();
    }

    private PwdCredentialAccount cloneWithToken(Account account, char[] token) {
        PwdCredentialAccount ret;
        if (account instanceof MongoRealmAccount) {
            MongoRealmAccount _account = (MongoRealmAccount)account;
            ret = new MongoRealmAccount(account.getPrincipal().getName(), token, (Set)Sets.newTreeSet((Iterable)account.getRoles()), _account.getAccountDocument());
        } else if (account instanceof FileRealmAccount) {
            FileRealmAccount _account = (FileRealmAccount)account;
            ret = new FileRealmAccount(account.getPrincipal().getName(), token, (Set)Sets.newTreeSet((Iterable)account.getRoles()), _account.getAccountProperties());
        } else {
            ret = new PwdCredentialAccount(account.getPrincipal().getName(), token, (Set)Sets.newTreeSet((Iterable)account.getRoles()));
        }
        return ret;
    }

    public void invalidate(Account account) {
        CACHE.invalidate((Object)account.getPrincipal().getName());
    }

    public void update(Account account) {
        String id = account.getPrincipal().getName();
        Optional _authTokenAccount = CACHE.get((Object)id);
        if (_authTokenAccount != null && _authTokenAccount.isPresent()) {
            PwdCredentialAccount authTokenAccount = (PwdCredentialAccount)_authTokenAccount.get();
            PwdCredentialAccount updatedAuthTokenAccount = this.cloneWithToken(account, authTokenAccount.getCredentials().getPassword());
            CACHE.put((Object)id, (Object)updatedAuthTokenAccount);
        }
    }

    public void injectTokenHeaders(HttpServerExchange exchange, PasswordCredential token) {
        exchange.getResponseHeaders().add(AUTH_TOKEN_HEADER, new String(token.getPassword()));
        exchange.getResponseHeaders().add(AUTH_TOKEN_VALID_HEADER, Instant.now().plus((long)this.ttl, ChronoUnit.MINUTES).toString());
        JsonProxyRequest request = JsonProxyRequest.of((HttpServerExchange)exchange);
        if (request.getAuthenticatedAccount() != null && request.getAuthenticatedAccount().getPrincipal() != null && request.getAuthenticatedAccount().getPrincipal().getName() != null) {
            String cid = request.getAuthenticatedAccount().getPrincipal().getName();
            exchange.getResponseHeaders().add(AUTH_TOKEN_LOCATION_HEADER, URLUtils.removeTrailingSlashes((String)this.srvURI).concat("/").concat(cid));
        }
    }

    private static char[] nextToken() {
        return new BigInteger(256, RND_GENERATOR).toString(36).toCharArray();
    }
}

