/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authorizers;

import io.undertow.predicate.PredicateParser;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.restheart.ConfigurationException;
import org.restheart.exchange.Request;
import org.restheart.security.AclVarsInterpolator;
import org.restheart.security.BaseAclPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoAclPermission
extends BaseAclPermission {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoAclPermission.class);
    private final BsonValue _id;

    MongoAclPermission(BsonValue _id, String requestPredicate, Set<String> roles, int priority, BsonDocument raw) throws ConfigurationException {
        super(req -> AclVarsInterpolator.interpolatePredicate((Request)req, (String)requestPredicate, (ClassLoader)MongoAclPermission.class.getClassLoader()).resolve(req.getExchange()), roles, priority, (Object)raw);
        this._id = _id;
    }

    static MongoAclPermission build(BsonDocument doc) throws ConfigurationException {
        int priority;
        BsonValue _id = doc.get((Object)"_id");
        BsonValue _roles = doc.get((Object)"roles");
        if (_roles == null || !_roles.isArray() || _roles.asArray().isEmpty()) {
            throw new ConfigurationException("Wrong permission: roles must be an not empty array of strings");
        }
        if (StreamSupport.stream(_roles.asArray().spliterator(), true).anyMatch(el -> el == null || !el.isString())) {
            throw new ConfigurationException("Wrong permission: roles must be an not empty array of strings");
        }
        Set<String> roles = StreamSupport.stream(_roles.asArray().spliterator(), true).map(role -> role.asString()).map(role -> role.getValue()).collect(Collectors.toSet());
        BsonValue argPredicate = doc.get((Object)"predicate");
        if (argPredicate == null || !argPredicate.isString()) {
            throw new ConfigurationException("Wrong permission: predicate must be a string");
        }
        try {
            PredicateParser.parse((String)argPredicate.asString().getValue(), (ClassLoader)MongoAclPermission.class.getClassLoader());
        }
        catch (Throwable t) {
            throw new ConfigurationException("Wrong permission: invalid predicate " + argPredicate, t);
        }
        BsonValue _priority = doc.get((Object)"priority");
        if (_priority == null || _priority.isNull() || !_priority.isNumber()) {
            priority = Integer.MAX_VALUE;
            LOGGER.warn("predicate {} doesn't have priority; setting it to very low priority", (Object)_id);
        } else {
            priority = _priority.asNumber().intValue();
        }
        return new MongoAclPermission(_id, argPredicate.asString().getValue(), roles, priority, doc);
    }

    public BsonValue getId() {
        return this._id;
    }
}

