/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authorizers;

import org.restheart.exchange.Request;
import org.restheart.plugins.InjectPluginsRegistry;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.Authorizer;

@RegisterPlugin(name="globalPredicatesVetoer", description="vetoes requests according to global predicates", enabledByDefault=true, authorizerType=Authorizer.TYPE.VETOER)
public class GlobalPredicatesVetoer
implements Authorizer {
    private PluginsRegistry registry;

    @InjectPluginsRegistry
    public void setPluginsRegistry(PluginsRegistry registry) {
        this.registry = registry;
    }

    public boolean isAllowed(Request request) {
        return this.registry.getGlobalSecurityPredicates().stream().allMatch(predicate -> predicate.resolve(request.getExchange()));
    }

    public boolean isAuthenticationRequired(Request request) {
        return false;
    }
}

